/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestInjectionForSimulatedStorage {
    private final int checksumSize = 16;
    private final int blockSize = 32;
    private final int numBlocks = 4;
    private final int filesize = 128;
    private final int numDataNodes = 4;
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestInjectionForSimulatedStorage");

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 32L);
        byte[] buffer = new byte[128];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = 49;
        }
        stm.write(buffer);
        stm.close();
    }

    private void waitForBlockReplication(String filename, ClientProtocol namenode, int expected, long maxWaitSec) throws IOException {
        long start = Time.monotonicNow();
        LOG.info((Object)("Checking for block replication for " + filename));
        LocatedBlocks blocks = namenode.getBlockLocations(filename, 0L, Long.MAX_VALUE);
        Assert.assertEquals((long)4L, (long)blocks.locatedBlockCount());
        for (int i = 0; i < 4; ++i) {
            int actual;
            LocatedBlock block;
            LOG.info((Object)("Checking for block:" + (i + 1)));
            while (true) {
                blocks = namenode.getBlockLocations(filename, 0L, Long.MAX_VALUE);
                Assert.assertEquals((long)4L, (long)blocks.locatedBlockCount());
                block = blocks.get(i);
                actual = block.getLocations().length;
                if (actual == expected) break;
                LOG.info((Object)("Not enough replicas for " + (i + 1) + "th block " + block.getBlock() + " yet. Expecting " + expected + ", got " + actual + "."));
                if (maxWaitSec > 0L && Time.monotonicNow() - start > maxWaitSec * 1000L) {
                    throw new IOException("Timedout while waiting for all blocks to  be replicated for " + filename);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            LOG.info((Object)("Got enough replicas for " + (i + 1) + "th block " + block.getBlock() + ", got " + actual + "."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInjection() throws IOException {
        MiniDFSCluster cluster = null;
        String testFile = "/replication-test-file";
        Path testPath = new Path(testFile);
        byte[] buffer = new byte[1024];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = 49;
        }
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.set("dfs.replication", Integer.toString(4));
            conf.setInt("dfs.bytes-per-checksum", 16);
            SimulatedFSDataset.setFactory((Configuration)conf);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            cluster.waitActive();
            String bpid = cluster.getNamesystem().getBlockPoolId();
            DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)conf);
            this.writeFile((FileSystem)cluster.getFileSystem(), testPath, 4);
            this.waitForBlockReplication(testFile, dfsClient.getNamenode(), 4, 20L);
            List<Map<DatanodeStorage, BlockListAsLongs>> blocksList = cluster.getAllBlockReports(bpid);
            cluster.shutdown();
            cluster = null;
            LOG.info((Object)"Restarting minicluster");
            conf = new HdfsConfiguration();
            SimulatedFSDataset.setFactory((Configuration)conf);
            conf.set("dfs.namenode.safemode.threshold-pct", "0.0f");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(8).format(false).build();
            cluster.waitActive();
            HashSet<Block> uniqueBlocks = new HashSet<Block>();
            for (Map<DatanodeStorage, BlockListAsLongs> map : blocksList) {
                for (BlockListAsLongs blockList : map.values()) {
                    for (Block b : blockList) {
                        uniqueBlocks.add(new Block(b));
                    }
                }
            }
            LOG.info((Object)("Inserting " + uniqueBlocks.size() + " blocks"));
            cluster.injectBlocks(0, uniqueBlocks, null);
            dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)conf);
            this.waitForBlockReplication(testFile, dfsClient.getNamenode(), 4, -1L);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

