/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.table;

import com.fasterxml.jackson.core.JsonParseException;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.RequestLocationMode;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.table.CloudTableClient;
import com.microsoft.azure.storage.table.EntityResolver;
import com.microsoft.azure.storage.table.TableDeserializer;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TableOperation;
import com.microsoft.azure.storage.table.TableOperationType;
import com.microsoft.azure.storage.table.TableRequest;
import com.microsoft.azure.storage.table.TableRequestOptions;
import com.microsoft.azure.storage.table.TableResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import javax.xml.stream.XMLStreamException;

public class QueryTableOperation
extends TableOperation {
    private EntityResolver<?> resolver;
    private Class<? extends TableEntity> clazzType;
    private String partitionKey;
    private String rowKey;
    private boolean isPrimaryOnlyRetrieve = false;

    protected QueryTableOperation() {
        super(null, TableOperationType.RETRIEVE);
    }

    QueryTableOperation(String partitionKey, String rowKey) {
        super(null, TableOperationType.RETRIEVE);
        Utility.assertNotNull("partitionKey", partitionKey);
        this.partitionKey = partitionKey;
        this.rowKey = rowKey;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public EntityResolver<?> getResolver() {
        return this.resolver;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    protected Class<? extends TableEntity> getClazzType() {
        return this.clazzType;
    }

    @Override
    protected TableResult parseResponse(InputStream inStream, int httpStatusCode, String etagFromHeader, OperationContext opContext, TableRequestOptions options) throws XMLStreamException, InstantiationException, IllegalAccessException, StorageException, JsonParseException, IOException {
        TableResult res = TableDeserializer.parseSingleOpResponse(inStream, options, httpStatusCode, this.getClazzType(), this.getResolver(), opContext);
        res.setEtag(etagFromHeader);
        return res;
    }

    protected TableResult performRetrieve(CloudTableClient client, String tableName, TableRequestOptions options, OperationContext opContext) throws StorageException {
        return ExecutionEngine.executeWithRetry(client, this, this.retrieveImpl(client, tableName, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudTableClient, QueryTableOperation, TableResult> retrieveImpl(CloudTableClient client, final String tableName, final TableRequestOptions options) {
        final boolean isTableEntry = "Tables".equals(tableName);
        if (this.getClazzType() != null) {
            Utility.checkNullaryCtor(this.getClazzType());
        } else {
            Utility.assertNotNull("Query requires a valid class type or resolver.", this.getResolver());
        }
        StorageRequest<CloudTableClient, QueryTableOperation, TableResult> getRequest = new StorageRequest<CloudTableClient, QueryTableOperation, TableResult>((RequestOptions)options, client.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(QueryTableOperation.this.isPrimaryOnlyRetrieve() ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudTableClient client, QueryTableOperation operation, OperationContext context) throws Exception {
                return TableRequest.query(client.getTransformedEndPoint(context).getUri(this.getCurrentLocation()), options, null, context, tableName, QueryTableOperation.this.generateRequestIdentity(isTableEntry, operation.getPartitionKey(), false), null);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                StorageRequest.signTableRequest(connection, client, -1L, context);
            }

            @Override
            public TableResult preProcessResponse(QueryTableOperation operation, CloudTableClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200 && this.getResult().getStatusCode() != 404) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public TableResult postProcessResponse(HttpURLConnection connection, QueryTableOperation operation, CloudTableClient client, OperationContext context, TableResult storageObject) throws Exception {
                if (this.getResult().getStatusCode() == 404) {
                    return new TableResult(this.getResult().getStatusCode());
                }
                InputStream inStream = connection.getInputStream();
                TableResult res = QueryTableOperation.this.parseResponse(inStream, this.getResult().getStatusCode(), this.getConnection().getHeaderField("ETag"), context, options);
                return res;
            }
        };
        return getRequest;
    }

    protected void setClazzType(Class<? extends TableEntity> clazzType) {
        Utility.assertNotNull("clazzType", clazzType);
        Utility.checkNullaryCtor(clazzType);
        this.clazzType = clazzType;
    }

    protected void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    protected void setResolver(EntityResolver<?> resolver) {
        Utility.assertNotNull("Query requires a valid class type or resolver.", resolver);
        this.resolver = resolver;
    }

    protected void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    protected final boolean isPrimaryOnlyRetrieve() {
        return this.isPrimaryOnlyRetrieve;
    }

    protected void setPrimaryOnlyRetrieve(boolean isPrimaryOnlyRetrieve) {
        this.isPrimaryOnlyRetrieve = isPrimaryOnlyRetrieve;
    }
}

