/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.BaseResponse;
import com.microsoft.azure.storage.core.PathUtility;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.FileAttributes;
import com.microsoft.azure.storage.file.FileDirectoryProperties;
import com.microsoft.azure.storage.file.FileProperties;
import com.microsoft.azure.storage.file.FileShareAttributes;
import com.microsoft.azure.storage.file.FileShareProperties;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;

final class FileResponse
extends BaseResponse {
    FileResponse() {
    }

    public static FileShareAttributes getFileShareAttributes(HttpURLConnection request, boolean usePathStyleUris) throws StorageException {
        URI tempURI;
        FileShareAttributes shareAttributes = new FileShareAttributes();
        try {
            tempURI = PathUtility.stripSingleURIQueryAndFragment(request.getURL().toURI());
        }
        catch (URISyntaxException e) {
            StorageException wrappedUnexpectedException = Utility.generateNewUnexpectedStorageException(e);
            throw wrappedUnexpectedException;
        }
        shareAttributes.setName(PathUtility.getShareNameFromUri(tempURI, usePathStyleUris));
        FileShareProperties shareProperties = shareAttributes.getProperties();
        shareProperties.setEtag(BaseResponse.getEtag(request));
        shareProperties.setLastModified(new Date(request.getLastModified()));
        shareAttributes.setMetadata(FileResponse.getMetadata(request));
        return shareAttributes;
    }

    public static FileDirectoryProperties getFileDirectoryProperties(HttpURLConnection request) {
        FileDirectoryProperties directoryProperties = new FileDirectoryProperties();
        directoryProperties.setEtag(BaseResponse.getEtag(request));
        directoryProperties.setLastModified(new Date(request.getLastModified()));
        return directoryProperties;
    }

    public static FileAttributes getFileAttributes(HttpURLConnection request, StorageUri resourceURI) {
        FileAttributes fileAttributes = new FileAttributes();
        FileProperties properties = fileAttributes.getProperties();
        properties.setCacheControl(request.getHeaderField("Cache-Control"));
        properties.setContentDisposition(request.getHeaderField("Content-Disposition"));
        properties.setContentEncoding(request.getHeaderField("Content-Encoding"));
        properties.setContentLanguage(request.getHeaderField("Content-Language"));
        properties.setContentMD5(request.getHeaderField("Content-MD5"));
        properties.setContentType(request.getHeaderField("Content-Type"));
        properties.setEtag(BaseResponse.getEtag(request));
        Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
        lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
        lastModifiedCalendar.setTime(new Date(request.getLastModified()));
        properties.setLastModified(lastModifiedCalendar.getTime());
        String rangeHeader = request.getHeaderField("Content-Range");
        String xContentLengthHeader = request.getHeaderField("x-ms-content-length");
        if (!Utility.isNullOrEmpty(rangeHeader)) {
            properties.setLength(Long.parseLong(rangeHeader.split("/")[1]));
        } else if (!Utility.isNullOrEmpty(xContentLengthHeader)) {
            properties.setLength(Long.parseLong(xContentLengthHeader));
        } else {
            String contentLength = request.getHeaderField("Content-Length");
            if (!Utility.isNullOrEmpty(contentLength)) {
                properties.setLength(Long.parseLong(contentLength));
            }
        }
        fileAttributes.setStorageUri(resourceURI);
        fileAttributes.setMetadata(BaseResponse.getMetadata(request));
        return fileAttributes;
    }
}

