/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.codec.http;

import com.datastax.shaded.netty.buffer.ChannelBuffer;
import com.datastax.shaded.netty.handler.codec.http.HttpMessage;
import com.datastax.shaded.netty.handler.codec.http.HttpMessageEncoder;
import com.datastax.shaded.netty.handler.codec.http.HttpRequest;

public class HttpRequestEncoder
extends HttpMessageEncoder {
    private static final char SLASH = '/';

    protected void encodeInitialLine(ChannelBuffer buf, HttpMessage message) throws Exception {
        HttpRequest request = (HttpRequest)message;
        buf.writeBytes(request.getMethod().toString().getBytes("ASCII"));
        buf.writeByte(32);
        String uri = request.getUri();
        int start = uri.indexOf("://");
        if (start != -1) {
            int startIndex = start + 3;
            if (uri.lastIndexOf(47) <= startIndex) {
                uri = uri + '/';
            }
        }
        buf.writeBytes(uri.getBytes("UTF-8"));
        buf.writeByte(32);
        buf.writeBytes(request.getProtocolVersion().toString().getBytes("ASCII"));
        buf.writeByte(13);
        buf.writeByte(10);
    }
}

