/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.shaded.netty.buffer.ChannelBuffer;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DataType {
    private final Name name;
    private final List<DataType> typeArguments;
    private final String customClassName;
    private final TypeCodec<?> codec;
    private static final Map<Name, DataType> primitiveTypeMap = new EnumMap<Name, DataType>(Name.class);
    private static final Set<DataType> primitiveTypeSet;

    private DataType(Name name, List<DataType> typeArguments, TypeCodec<?> codec) {
        this(name, typeArguments, null, codec);
    }

    private DataType(Name name, List<DataType> typeArguments, String customClassName, TypeCodec<?> codec) {
        this.name = name;
        this.typeArguments = typeArguments;
        this.customClassName = customClassName;
        this.codec = codec;
    }

    static DataType decode(ChannelBuffer buffer) {
        Name name = Name.fromProtocolId(buffer.readUnsignedShort());
        switch (name) {
            case CUSTOM: {
                return DataType.custom(CBUtil.readString(buffer));
            }
            case LIST: {
                return DataType.list(DataType.decode(buffer));
            }
            case SET: {
                return DataType.set(DataType.decode(buffer));
            }
            case MAP: {
                DataType keys = DataType.decode(buffer);
                DataType values = DataType.decode(buffer);
                return DataType.map(keys, values);
            }
        }
        return primitiveTypeMap.get((Object)name);
    }

    TypeCodec<Object> codec() {
        return this.codec;
    }

    public static DataType ascii() {
        return primitiveTypeMap.get((Object)Name.ASCII);
    }

    public static DataType bigint() {
        return primitiveTypeMap.get((Object)Name.BIGINT);
    }

    public static DataType blob() {
        return primitiveTypeMap.get((Object)Name.BLOB);
    }

    public static DataType cboolean() {
        return primitiveTypeMap.get((Object)Name.BOOLEAN);
    }

    public static DataType counter() {
        return primitiveTypeMap.get((Object)Name.COUNTER);
    }

    public static DataType decimal() {
        return primitiveTypeMap.get((Object)Name.DECIMAL);
    }

    public static DataType cdouble() {
        return primitiveTypeMap.get((Object)Name.DOUBLE);
    }

    public static DataType cfloat() {
        return primitiveTypeMap.get((Object)Name.FLOAT);
    }

    public static DataType inet() {
        return primitiveTypeMap.get((Object)Name.INET);
    }

    public static DataType cint() {
        return primitiveTypeMap.get((Object)Name.INT);
    }

    public static DataType text() {
        return primitiveTypeMap.get((Object)Name.TEXT);
    }

    public static DataType timestamp() {
        return primitiveTypeMap.get((Object)Name.TIMESTAMP);
    }

    public static DataType uuid() {
        return primitiveTypeMap.get((Object)Name.UUID);
    }

    public static DataType varchar() {
        return primitiveTypeMap.get((Object)Name.VARCHAR);
    }

    public static DataType varint() {
        return primitiveTypeMap.get((Object)Name.VARINT);
    }

    public static DataType timeuuid() {
        return primitiveTypeMap.get((Object)Name.TIMEUUID);
    }

    public static DataType list(DataType elementType) {
        return new DataType(Name.LIST, (List<DataType>)ImmutableList.of((Object)elementType), TypeCodec.listOf(elementType));
    }

    public static DataType set(DataType elementType) {
        return new DataType(Name.SET, (List<DataType>)ImmutableList.of((Object)elementType), TypeCodec.setOf(elementType));
    }

    public static DataType map(DataType keyType, DataType valueType) {
        return new DataType(Name.MAP, (List<DataType>)ImmutableList.of((Object)keyType, (Object)valueType), TypeCodec.mapOf(keyType, valueType));
    }

    public static DataType custom(String typeClassName) {
        if (typeClassName == null) {
            throw new NullPointerException();
        }
        return new DataType(Name.CUSTOM, Collections.<DataType>emptyList(), typeClassName, TypeCodec.createFor(Name.CUSTOM));
    }

    public Name getName() {
        return this.name;
    }

    public List<DataType> getTypeArguments() {
        return this.typeArguments;
    }

    public String getCustomTypeClassName() {
        return this.customClassName;
    }

    public ByteBuffer parse(String value) {
        if (this.name == Name.CUSTOM) {
            throw new InvalidTypeException(String.format("Cannot parse '%s' as value of custom type of class '%s' (values for custom type cannot be parse and must be inputted as bytes directly)", value, this.customClassName));
        }
        if (this.name.isCollection()) {
            throw new InvalidTypeException(String.format("Cannot parse value as %s, parsing collections is not currently supported", new Object[]{this.name}));
        }
        return this.codec().serialize(this.codec.parse(value));
    }

    public boolean isCollection() {
        return this.name.isCollection();
    }

    public Class<?> asJavaClass() {
        return this.getName().asJavaClass();
    }

    public static Set<DataType> allPrimitiveTypes() {
        return primitiveTypeSet;
    }

    public ByteBuffer serialize(Object value) {
        Class<?> providedClass = value.getClass();
        Class<?> expectedClass = this.asJavaClass();
        if (!expectedClass.isAssignableFrom(providedClass)) {
            throw new InvalidTypeException(String.format("Invalid value for CQL type %s, expecting %s but %s provided", this.toString(), expectedClass, providedClass));
        }
        try {
            return this.codec().serialize(value);
        }
        catch (ClassCastException e) {
            throw new InvalidTypeException("Invalid type for collection element: " + e.getMessage());
        }
    }

    public Object deserialize(ByteBuffer bytes) {
        return this.codec().deserialize(bytes);
    }

    public static ByteBuffer serializeValue(Object value) {
        if (value == null) {
            return null;
        }
        DataType dt = TypeCodec.getDataTypeFor(value);
        if (dt == null) {
            throw new IllegalArgumentException(String.format("Value of type %s does not correspond to any CQL3 type", value.getClass()));
        }
        try {
            return dt.serialize(value);
        }
        catch (InvalidTypeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.typeArguments, this.customClassName});
    }

    public final boolean equals(Object o) {
        if (!(o instanceof DataType)) {
            return false;
        }
        DataType d = (DataType)o;
        return this.name == d.name && this.typeArguments.equals(d.typeArguments) && Objects.equal((Object)this.customClassName, (Object)d.customClassName);
    }

    public String toString() {
        switch (this.name) {
            case LIST: 
            case SET: {
                return String.format("%s<%s>", new Object[]{this.name, this.typeArguments.get(0)});
            }
            case MAP: {
                return String.format("%s<%s, %s>", new Object[]{this.name, this.typeArguments.get(0), this.typeArguments.get(1)});
            }
            case CUSTOM: {
                return String.format("'%s'", this.customClassName);
            }
        }
        return this.name.toString();
    }

    static {
        for (Name name : Name.values()) {
            if (name.isCollection() || name == Name.CUSTOM) continue;
            primitiveTypeMap.put(name, new DataType(name, Collections.<DataType>emptyList(), TypeCodec.createFor(name)));
        }
        primitiveTypeSet = ImmutableSet.copyOf(primitiveTypeMap.values());
    }

    public static enum Name {
        ASCII(1, String.class),
        BIGINT(2, Long.class),
        BLOB(3, ByteBuffer.class),
        BOOLEAN(4, Boolean.class),
        COUNTER(5, Long.class),
        DECIMAL(6, BigDecimal.class),
        DOUBLE(7, Double.class),
        FLOAT(8, Float.class),
        INET(16, InetAddress.class),
        INT(9, Integer.class),
        TEXT(10, String.class),
        TIMESTAMP(11, Date.class),
        UUID(12, UUID.class),
        VARCHAR(13, String.class),
        VARINT(14, BigInteger.class),
        TIMEUUID(15, UUID.class),
        LIST(32, List.class),
        SET(34, Set.class),
        MAP(33, Map.class),
        CUSTOM(0, ByteBuffer.class);

        final int protocolId;
        final Class<?> javaType;
        private static final Name[] nameToIds;

        private Name(int protocolId, Class<?> javaType) {
            this.protocolId = protocolId;
            this.javaType = javaType;
        }

        static Name fromProtocolId(int id) {
            Name name = nameToIds[id];
            if (name == null) {
                throw new DriverInternalError("Unknown data type protocol id: " + id);
            }
            return name;
        }

        public boolean isCollection() {
            switch (this) {
                case LIST: 
                case SET: 
                case MAP: {
                    return true;
                }
            }
            return false;
        }

        public Class<?> asJavaClass() {
            return this.javaType;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        static {
            int maxCode = -1;
            for (Name name : Name.values()) {
                maxCode = Math.max(maxCode, name.protocolId);
            }
            nameToIds = new Name[maxCode + 1];
            for (Name name : Name.values()) {
                if (nameToIds[name.protocolId] != null) {
                    throw new IllegalStateException("Duplicate Id");
                }
                Name.nameToIds[name.protocolId] = name;
            }
        }
    }
}

