/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import jline.Completion;
import jline.CompletionHandler;
import jline.ConsoleReader;
import jline.CursorBuffer;

public class CandidateListCompletionHandler
implements CompletionHandler {
    private static ResourceBundle loc = ResourceBundle.getBundle((class$jline$CandidateListCompletionHandler == null ? (class$jline$CandidateListCompletionHandler = CandidateListCompletionHandler.class$("jline.CandidateListCompletionHandler")) : class$jline$CandidateListCompletionHandler).getName());
    private boolean eagerNewlines = true;
    static /* synthetic */ Class class$jline$CandidateListCompletionHandler;

    public void setAlwaysIncludeNewline(boolean eagerNewlines) {
        this.eagerNewlines = eagerNewlines;
    }

    public boolean complete(ConsoleReader reader, List candidates, int pos) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        ArrayList convertedCandidates = new ArrayList();
        for (int i = 0; i < candidates.size(); ++i) {
            Object object = candidates.get(i);
            if (object instanceof Completion) {
                convertedCandidates.add(object);
                continue;
            }
            convertedCandidates.add(new Completion(object.toString()));
        }
        if (convertedCandidates.size() == 1) {
            Completion completion = (Completion)convertedCandidates.get(0);
            String value = completion.getValue();
            if (value.equals(buf.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
            return true;
        }
        if (convertedCandidates.size() > 1) {
            String value = this.getUnambiguousCompletions(convertedCandidates);
            CandidateListCompletionHandler.setBuffer(reader, value, pos);
        }
        if (this.eagerNewlines) {
            reader.printNewline();
        }
        CandidateListCompletionHandler.printCandidates(reader, convertedCandidates, this.eagerNewlines);
        reader.drawLine();
        return true;
    }

    public static void setBuffer(ConsoleReader reader, String value, int offset) throws IOException {
        while (reader.getCursorBuffer().cursor > offset && reader.backspace()) {
        }
        reader.putString(value);
        reader.setCursorPosition(offset + value.length());
    }

    public static final void printCandidates(ConsoleReader reader, Collection candidates, boolean eagerNewlines) throws IOException {
        LinkedHashSet distinct = new LinkedHashSet(candidates);
        if (distinct.size() > reader.getAutoprintThreshhold()) {
            int c;
            if (!eagerNewlines) {
                reader.printNewline();
            }
            reader.printString(MessageFormat.format(loc.getString("display-candidates"), new Integer(candidates.size())) + " ");
            reader.flushConsole();
            String noOpt = loc.getString("display-candidates-no");
            String yesOpt = loc.getString("display-candidates-yes");
            while ((c = reader.readCharacter(new char[]{yesOpt.charAt(0), noOpt.charAt(0)})) != -1) {
                if (noOpt.startsWith(new String(new char[]{(char)c}))) {
                    reader.printNewline();
                    return;
                }
                if (yesOpt.startsWith(new String(new char[]{(char)c}))) {
                    reader.printNewline();
                    break;
                }
                reader.beep();
            }
        }
        if (distinct.size() != candidates.size()) {
            ArrayList copy = new ArrayList();
            Iterator i = candidates.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (copy.contains(next)) continue;
                copy.add(next);
            }
            candidates = copy;
        }
        reader.printNewline();
        reader.printColumns(candidates);
    }

    private final String getUnambiguousCompletions(List candidates) {
        if (candidates == null || candidates.size() == 0) {
            return null;
        }
        Completion[] strings = candidates.toArray(new Completion[candidates.size()]);
        Completion completion = strings[0];
        String first = completion.getValue();
        StringBuffer candidate = new StringBuffer();
        for (int i = 0; i < first.length() && this.startsWith(first.substring(0, i + 1), strings); ++i) {
            candidate.append(first.charAt(i));
        }
        return candidate.toString();
    }

    private final boolean startsWith(String starts, Completion[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].getValue().startsWith(starts)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

