/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import java.io.IOException;
import java.util.HashMap;

public final class QueryRecordCommand
extends MultiCommand {
    private final Policy policy;
    private final Statement statement;
    private final RecordSet recordSet;

    public QueryRecordCommand(Node node, Policy policy, Statement statement, RecordSet recordSet) {
        super(node);
        this.policy = policy;
        this.statement = statement;
        this.recordSet = recordSet;
    }

    @Override
    protected final Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected final void writeBuffer() throws AerospikeException {
        this.setQuery(this.policy, this.statement, false);
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.dataOffset = 0;
        while (this.dataOffset < receiveSize) {
            this.readBytes(22);
            int resultCode = this.dataBuffer[5] & 0xFF;
            if (resultCode != 0) {
                if (resultCode == 2) {
                    return false;
                }
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.dataBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int generation = Buffer.bytesToInt(this.dataBuffer, 6);
            int expiration = Buffer.bytesToInt(this.dataBuffer, 10);
            int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
            int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
            Key key = this.parseKey(fieldCount);
            HashMap<String, Object> bins = null;
            for (int i = 0; i < opCount; ++i) {
                this.readBytes(8);
                int opSize = Buffer.bytesToInt(this.dataBuffer, 0);
                byte particleType = this.dataBuffer[5];
                byte nameSize = this.dataBuffer[7];
                this.readBytes(nameSize);
                String name = Buffer.utf8ToString(this.dataBuffer, 0, nameSize);
                int particleBytesSize = opSize - (4 + nameSize);
                this.readBytes(particleBytesSize);
                Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, 0, particleBytesSize);
                if (bins == null) {
                    bins = new HashMap<String, Object>();
                }
                bins.put(name, value);
            }
            Record record = new Record(bins, generation, expiration);
            if (!this.valid) {
                throw new AerospikeException.QueryTerminated();
            }
            if (this.recordSet.put(new KeyRecord(key, record))) continue;
            this.stop();
            throw new AerospikeException.QueryTerminated();
        }
        return true;
    }
}

