/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.Statement;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import org.luaj.vm2.LuaValue;

public final class QueryAggregateCommand
extends MultiCommand {
    private final Policy policy;
    private final Statement statement;
    private final LuaInstance instance;
    private final BlockingQueue<LuaValue> inputQueue;

    public QueryAggregateCommand(Node node, Policy policy, Statement statement, LuaInstance instance, BlockingQueue<LuaValue> inputQueue) {
        super(node);
        this.policy = policy;
        this.statement = statement;
        this.instance = instance;
        this.inputQueue = inputQueue;
    }

    @Override
    protected final Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected final void writeBuffer() throws AerospikeException {
        this.setQuery(this.policy, this.statement, false);
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.dataOffset = 0;
        while (this.dataOffset < receiveSize) {
            this.readBytes(22);
            int resultCode = this.dataBuffer[5] & 0xFF;
            if (resultCode != 0) {
                if (resultCode == 2) {
                    return false;
                }
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.dataBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
            int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
            this.parseKey(fieldCount);
            if (opCount != 1) {
                throw new AerospikeException("Query aggregate expected exactly one bin.  Received " + opCount);
            }
            this.readBytes(8);
            int opSize = Buffer.bytesToInt(this.dataBuffer, 0);
            byte particleType = this.dataBuffer[5];
            byte nameSize = this.dataBuffer[7];
            this.readBytes(nameSize);
            String name = Buffer.utf8ToString(this.dataBuffer, 0, nameSize);
            int particleBytesSize = opSize - (4 + nameSize);
            this.readBytes(particleBytesSize);
            if (!name.equals("SUCCESS")) {
                if (name.equals("FAILURE")) {
                    Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, 0, particleBytesSize);
                    throw new AerospikeException(213, value.toString());
                }
                throw new AerospikeException(213, "Query aggregate expected bin name SUCCESS.  Received " + name);
            }
            LuaValue aggregateValue = this.instance.getLuaValue(particleType, this.dataBuffer, 0, particleBytesSize);
            if (!this.valid) {
                throw new AerospikeException.QueryTerminated();
            }
            if (aggregateValue == null) continue;
            try {
                this.inputQueue.put(aggregateValue);
            }
            catch (InterruptedException ie) {}
        }
        return true;
    }
}

