/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.query.IndexCollectionType;

public final class Filter {
    private final String name;
    private final IndexCollectionType type;
    private final Value begin;
    private final Value end;

    public static Filter equal(String name, long value) {
        Value val = Value.get(value);
        return new Filter(name, IndexCollectionType.DEFAULT, val, val);
    }

    public static Filter equal(String name, String value) {
        Value val = Value.get(value);
        return new Filter(name, IndexCollectionType.DEFAULT, val, val);
    }

    public static Filter equal(String name, Value value) {
        return new Filter(name, IndexCollectionType.DEFAULT, value, value);
    }

    public static Filter contains(String name, IndexCollectionType type, long value) {
        Value val = Value.get(value);
        return new Filter(name, type, val, val);
    }

    public static Filter contains(String name, IndexCollectionType type, String value) {
        Value val = Value.get(value);
        return new Filter(name, type, val, val);
    }

    public static Filter range(String name, long begin, long end) {
        return new Filter(name, IndexCollectionType.DEFAULT, Value.get(begin), Value.get(end));
    }

    public static Filter range(String name, IndexCollectionType type, long begin, long end) {
        return new Filter(name, type, Value.get(begin), Value.get(end));
    }

    public static Filter range(String name, Value begin, Value end) {
        return new Filter(name, IndexCollectionType.DEFAULT, begin, end);
    }

    private Filter(String name, IndexCollectionType type, Value begin, Value end) {
        this.name = name;
        this.type = type;
        this.begin = begin;
        this.end = end;
    }

    public int estimateSize() throws AerospikeException {
        return Buffer.estimateSizeUtf8(this.name) + this.begin.estimateSize() + this.end.estimateSize() + 10;
    }

    public int write(byte[] buf, int offset) throws AerospikeException {
        int len = Buffer.stringToUtf8(this.name, buf, offset + 1);
        buf[offset] = (byte)len;
        offset += len + 1;
        buf[offset++] = (byte)this.begin.getType();
        len = this.begin.write(buf, offset + 4);
        Buffer.intToBytes(len, buf, offset);
        offset += len + 4;
        len = this.end.write(buf, offset + 4);
        Buffer.intToBytes(len, buf, offset);
        return offset += len + 4;
    }

    public IndexCollectionType getCollectionType() {
        return this.type;
    }
}

