/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.large;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.util.Util;
import java.util.List;
import java.util.Map;

public class LargeStack {
    private static final String PackageName = "lstack";
    private final AerospikeClient client;
    private final WritePolicy policy;
    private final Key key;
    private final Value binName;
    private final Value createModule;

    public LargeStack(AerospikeClient client, WritePolicy policy, Key key, String binName, String createModule) {
        this.client = client;
        this.policy = policy;
        this.key = key;
        this.binName = Value.get(binName);
        this.createModule = Value.get(createModule);
    }

    public void push(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "push", this.binName, value, this.createModule);
    }

    public void push(Value ... values) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "push_all", this.binName, Value.get(values), this.createModule);
    }

    public void push(List<?> values) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "push_all", this.binName, Value.get(values), this.createModule);
    }

    public List<?> peek(int peekCount) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "peek", this.binName, Value.get(peekCount));
    }

    public List<?> scan() throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "scan", this.binName);
    }

    public List<?> filter(int peekCount, String filterModule, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "filter", this.binName, Value.get(peekCount), Value.get(filterModule), Value.get(filterName), Value.get(filterArgs));
    }

    public void destroy() throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "destroy", this.binName);
    }

    public int size() throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "size", this.binName);
        return Util.toInt(result);
    }

    public Map<?, ?> getConfig() throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "get_config", this.binName);
    }

    public void setCapacity(int capacity) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "set_capacity", this.binName, Value.get(capacity));
    }

    public int getCapacity() throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "get_capacity", this.binName);
        return Util.toInt(result);
    }
}

