/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.WritePolicy;
import java.io.IOException;

public final class TouchCommand
extends SyncCommand {
    private final Cluster cluster;
    private final WritePolicy policy;
    private final Key key;
    private final Partition partition;

    public TouchCommand(Cluster cluster, WritePolicy policy, Key key) {
        this.cluster = cluster;
        this.policy = policy;
        this.key = key;
        this.partition = new Partition(key);
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() {
        this.setTouch(this.policy, this.key);
    }

    @Override
    protected Node getNode() {
        return this.cluster.getMasterNode(this.partition);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        conn.readFully(this.dataBuffer, 30);
        int resultCode = this.dataBuffer[13] & 0xFF;
        if (resultCode != 0) {
            throw new AerospikeException(resultCode);
        }
        this.emptySocket(conn);
    }
}

