/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.ScanPolicy;
import java.io.IOException;
import java.util.HashMap;

public final class ScanCommand
extends MultiCommand {
    private final ScanPolicy policy;
    private final String namespace;
    private final String setName;
    private final ScanCallback callback;
    private final String[] binNames;
    private final long taskId;

    public ScanCommand(Node node, ScanPolicy policy, String namespace, String setName, ScanCallback callback, String[] binNames, long taskId) {
        super(node);
        this.policy = policy;
        this.namespace = namespace;
        this.setName = setName;
        this.callback = callback;
        this.binNames = binNames;
        this.taskId = taskId;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setScan(this.policy, this.namespace, this.setName, this.binNames, this.taskId);
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.dataOffset = 0;
        while (this.dataOffset < receiveSize) {
            this.readBytes(22);
            int resultCode = this.dataBuffer[5] & 0xFF;
            if (resultCode != 0) {
                if (resultCode == 2) {
                    return false;
                }
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.dataBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int generation = Buffer.bytesToInt(this.dataBuffer, 6);
            int expiration = Buffer.bytesToInt(this.dataBuffer, 10);
            int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
            int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
            Key key = this.parseKey(fieldCount);
            HashMap<String, Object> bins = null;
            for (int i = 0; i < opCount; ++i) {
                this.readBytes(8);
                int opSize = Buffer.bytesToInt(this.dataBuffer, 0);
                byte particleType = this.dataBuffer[5];
                byte nameSize = this.dataBuffer[7];
                this.readBytes(nameSize);
                String name = Buffer.utf8ToString(this.dataBuffer, 0, nameSize);
                int particleBytesSize = opSize - (4 + nameSize);
                this.readBytes(particleBytesSize);
                Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, 0, particleBytesSize);
                if (bins == null) {
                    bins = new HashMap<String, Object>();
                }
                bins.put(name, value);
            }
            if (!this.valid) {
                throw new AerospikeException.ScanTerminated();
            }
            this.callback.scanCallback(key, new Record(bins, generation, expiration));
        }
        return true;
    }
}

