/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;

public class ReadHeaderCommand
extends SyncCommand {
    private final Cluster cluster;
    private final Policy policy;
    private final Key key;
    private final Partition partition;
    private Record record;

    public ReadHeaderCommand(Cluster cluster, Policy policy, Key key) {
        this.cluster = cluster;
        this.policy = policy;
        this.key = key;
        this.partition = new Partition(key);
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() {
        this.setReadHeader(this.policy, this.key);
    }

    @Override
    protected Node getNode() {
        return this.cluster.getReadNode(this.partition, this.policy.replica);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        conn.readFully(this.dataBuffer, 30);
        int resultCode = this.dataBuffer[13] & 0xFF;
        if (resultCode == 0) {
            int generation = Buffer.bytesToInt(this.dataBuffer, 14);
            int expiration = Buffer.bytesToInt(this.dataBuffer, 18);
            this.record = new Record(null, generation, expiration);
        } else if (resultCode == 2) {
            this.record = null;
        } else {
            throw new AerospikeException(resultCode);
        }
        this.emptySocket(conn);
    }

    public Record getRecord() {
        return this.record;
    }
}

