/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;
import java.util.HashMap;

public class ReadCommand
extends SyncCommand {
    protected final Cluster cluster;
    private final Policy policy;
    protected final Key key;
    protected final Partition partition;
    private final String[] binNames;
    private Record record;

    public ReadCommand(Cluster cluster, Policy policy, Key key, String[] binNames) {
        this.cluster = cluster;
        this.policy = policy;
        this.key = key;
        this.partition = new Partition(key);
        this.binNames = binNames;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() {
        this.setRead(this.policy, this.key, this.binNames);
    }

    @Override
    protected Node getNode() {
        return this.cluster.getReadNode(this.partition, this.policy.replica);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        conn.readFully(this.dataBuffer, 30);
        long sz = Buffer.bytesToLong(this.dataBuffer, 0);
        byte headerLength = this.dataBuffer[8];
        int resultCode = this.dataBuffer[13] & 0xFF;
        int generation = Buffer.bytesToInt(this.dataBuffer, 14);
        int expiration = Buffer.bytesToInt(this.dataBuffer, 18);
        int fieldCount = Buffer.bytesToShort(this.dataBuffer, 26);
        int opCount = Buffer.bytesToShort(this.dataBuffer, 28);
        int receiveSize = (int)(sz & 0xFFFFFFFFFFFFL) - headerLength;
        if (receiveSize > 0) {
            this.sizeBuffer(receiveSize);
            conn.readFully(this.dataBuffer, receiveSize);
        }
        if (resultCode != 0) {
            if (resultCode == 2 || resultCode == 125) {
                return;
            }
            if (resultCode == 100) {
                this.record = this.parseRecord(opCount, fieldCount, generation, expiration);
                this.handleUdfError(resultCode);
                return;
            }
            throw new AerospikeException(resultCode);
        }
        if (opCount == 0) {
            this.record = new Record(null, generation, expiration);
            return;
        }
        this.record = this.parseRecord(opCount, fieldCount, generation, expiration);
    }

    private void handleUdfError(int resultCode) throws AerospikeException {
        String message;
        int code;
        String ret = (String)this.record.bins.get("FAILURE");
        if (ret == null) {
            throw new AerospikeException(resultCode);
        }
        try {
            String[] list = ret.split(":");
            code = Integer.parseInt(list[2].trim());
            if (code == 125) {
                this.record = null;
                return;
            }
            message = list[0] + ':' + list[1] + ' ' + list[3];
        }
        catch (Exception e) {
            throw new AerospikeException(resultCode, ret);
        }
        throw new AerospikeException(code, message);
    }

    private final Record parseRecord(int opCount, int fieldCount, int generation, int expiration) throws AerospikeException {
        int i;
        HashMap<String, Object> bins = null;
        int receiveOffset = 0;
        if (fieldCount > 0) {
            for (i = 0; i < fieldCount; ++i) {
                int fieldSize = Buffer.bytesToInt(this.dataBuffer, receiveOffset);
                receiveOffset += 4 + fieldSize;
            }
        }
        for (i = 0; i < opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.dataBuffer, receiveOffset);
            byte particleType = this.dataBuffer[receiveOffset + 5];
            byte nameSize = this.dataBuffer[receiveOffset + 7];
            String name = Buffer.utf8ToString(this.dataBuffer, receiveOffset + 8, nameSize);
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, receiveOffset += 8 + nameSize, particleBytesSize);
            receiveOffset += particleBytesSize;
            if (bins == null) {
                bins = new HashMap<String, Object>();
            }
            bins.put(name, value);
        }
        return new Record(bins, generation, expiration);
    }

    public Record getRecord() {
        return this.record;
    }
}

