/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.policy.BatchPolicy;
import java.util.ArrayList;
import java.util.List;

public final class BatchNode {
    public final Node node;
    public final List<BatchNamespace> batchNamespaces;
    public final int keyCapacity;

    public static List<BatchNode> generateList(Cluster cluster, BatchPolicy policy, Key[] keys) throws AerospikeException {
        Node[] nodes = cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Command failed because cluster is empty.");
        }
        int nodeCount = nodes.length;
        int keysPerNode = keys.length / nodeCount + 10;
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodeCount + 1);
        for (int i = 0; i < keys.length; ++i) {
            Key key = keys[i];
            Partition partition = new Partition(key);
            Node node = cluster.getReadNode(partition, policy.replica);
            BatchNode batchNode = BatchNode.findBatchNode(batchNodes, node);
            if (batchNode == null) {
                batchNodes.add(new BatchNode(node, keysPerNode, key.namespace, i));
                continue;
            }
            batchNode.addKey(key.namespace, i);
        }
        return batchNodes;
    }

    public BatchNode(Node node, int keyCapacity, String namespace, int offset) {
        this.node = node;
        this.keyCapacity = keyCapacity;
        this.batchNamespaces = new ArrayList<BatchNamespace>(4);
        this.batchNamespaces.add(new BatchNamespace(namespace, keyCapacity, offset));
    }

    public void addKey(String namespace, int offset) {
        BatchNamespace batchNamespace = this.findNamespace(namespace);
        if (batchNamespace == null) {
            this.batchNamespaces.add(new BatchNamespace(namespace, this.keyCapacity, offset));
        } else {
            batchNamespace.add(offset);
        }
    }

    private BatchNamespace findNamespace(String ns) {
        for (BatchNamespace batchNamespace : this.batchNamespaces) {
            if (batchNamespace.namespace != ns && !batchNamespace.namespace.equals(ns)) continue;
            return batchNamespace;
        }
        return null;
    }

    private static BatchNode findBatchNode(List<BatchNode> nodes, Node node) {
        for (BatchNode batchNode : nodes) {
            if (batchNode.node != node) continue;
            return batchNode;
        }
        return null;
    }

    public static final class BatchNamespace {
        public final String namespace;
        public int[] offsets;
        public int offsetsSize;

        public BatchNamespace(String namespace, int capacity, int offset) {
            this.namespace = namespace;
            this.offsets = new int[capacity];
            this.offsets[0] = offset;
            this.offsetsSize = 1;
        }

        public void add(int offset) {
            if (this.offsetsSize >= this.offsets.length) {
                int[] copy = new int[this.offsetsSize * 2];
                System.arraycopy(this.offsets, 0, copy, 0, this.offsetsSize);
                this.offsets = copy;
            }
            this.offsets[this.offsetsSize++] = offset;
        }
    }
}

