/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public final class BatchCommandGet
extends MultiCommand {
    private final BatchNode.BatchNamespace batch;
    private final Policy policy;
    private final Key[] keys;
    private final HashSet<String> binNames;
    private final Record[] records;
    private final int readAttr;
    private int index;

    public BatchCommandGet(Node node, BatchNode.BatchNamespace batch, Policy policy, Key[] keys, HashSet<String> binNames, Record[] records, int readAttr) {
        super(node);
        this.batch = batch;
        this.policy = policy;
        this.keys = keys;
        this.binNames = binNames;
        this.records = records;
        this.readAttr = readAttr;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setBatchGet(this.policy, this.keys, this.batch, this.binNames, this.readAttr);
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.dataOffset = 0;
        while (this.dataOffset < receiveSize) {
            this.readBytes(22);
            int resultCode = this.dataBuffer[5] & 0xFF;
            if (resultCode != 0 && resultCode != 2) {
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.dataBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int generation = Buffer.bytesToInt(this.dataBuffer, 6);
            int expiration = Buffer.bytesToInt(this.dataBuffer, 10);
            int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
            int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
            Key key = this.parseKey(fieldCount);
            int offset = this.batch.offsets[this.index++];
            if (Arrays.equals(key.digest, this.keys[offset].digest)) {
                if (resultCode != 0) continue;
                this.records[offset] = this.parseRecord(opCount, generation, expiration);
                continue;
            }
            throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
        }
        return true;
    }

    protected Record parseRecord(int opCount, int generation, int expiration) throws AerospikeException, IOException {
        HashMap<String, Object> bins = null;
        for (int i = 0; i < opCount; ++i) {
            if (!this.valid) {
                throw new AerospikeException.QueryTerminated();
            }
            this.readBytes(8);
            int opSize = Buffer.bytesToInt(this.dataBuffer, 0);
            byte particleType = this.dataBuffer[5];
            byte nameSize = this.dataBuffer[7];
            this.readBytes(nameSize);
            String name = Buffer.utf8ToString(this.dataBuffer, 0, nameSize);
            int particleBytesSize = opSize - (4 + nameSize);
            this.readBytes(particleBytesSize);
            Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, 0, particleBytesSize);
            if (this.binNames != null && !this.binNames.contains(name)) continue;
            if (bins == null) {
                bins = new HashMap<String, Object>();
            }
            bins.put(name, value);
        }
        return new Record(bins, generation, expiration);
    }
}

