/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.Key;
import com.aerospike.client.command.Buffer;

public final class Partition {
    public final String namespace;
    public final int partitionId;

    public Partition(Key key) {
        this.namespace = key.namespace;
        this.partitionId = (Buffer.littleBytesToInt(key.digest, 0) & 0xFFFF) % 4096;
    }

    public Partition(String namespace, int partitionId) {
        this.namespace = namespace;
        this.partitionId = partitionId;
    }

    public String toString() {
        return this.namespace + ':' + this.partitionId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.namespace.hashCode();
        result = 31 * result + this.partitionId;
        return result;
    }

    public boolean equals(Object obj) {
        Partition other = (Partition)obj;
        return this.namespace.equals(other.namespace) && this.partitionId == other.partitionId;
    }
}

