/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.policy.Policy;
import java.nio.ByteBuffer;

public final class AsyncExists
extends AsyncSingleCommand {
    private final Policy policy;
    private final ExistsListener listener;
    private final Key key;
    private final Partition partition;
    private boolean exists;

    public AsyncExists(AsyncCluster cluster, Policy policy, ExistsListener listener, Key key) {
        super(cluster);
        this.policy = policy;
        this.listener = listener;
        this.key = key;
        this.partition = new Partition(key);
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() {
        this.setExists(this.policy, this.key);
    }

    @Override
    protected AsyncNode getNode() {
        return (AsyncNode)this.cluster.getReadNode(this.partition, this.policy.replica);
    }

    @Override
    protected void parseResult(ByteBuffer byteBuffer) {
        int resultCode = byteBuffer.get(5) & 0xFF;
        if (resultCode == 0) {
            this.exists = true;
        } else if (resultCode == 2) {
            this.exists = false;
        } else {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.exists);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

