/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.Policy;
import java.util.Arrays;

public final class AsyncBatchExistsArray
extends AsyncMultiCommand {
    private final BatchNode.BatchNamespace batch;
    private final Policy policy;
    private final Key[] keys;
    private final boolean[] existsArray;
    private int index;

    public AsyncBatchExistsArray(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node, BatchNode.BatchNamespace batchNamespace, Policy policy, Key[] keys, boolean[] existsArray) {
        super(parent, cluster, node, false);
        this.batch = batchNamespace;
        this.policy = policy;
        this.keys = keys;
        this.existsArray = existsArray;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setBatchExists(this.policy, this.keys, this.batch);
    }

    @Override
    protected void parseRow(Key key) throws AerospikeException {
        if (this.opCount > 0) {
            throw new AerospikeException.Parse("Received bins that were not requested!");
        }
        int offset = this.batch.offsets[this.index++];
        if (!Arrays.equals(key.digest, this.keys[offset].digest)) {
            throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
        }
        this.existsArray[offset] = this.resultCode == 0;
    }
}

