/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import java.util.Map;

public final class Record {
    public final Map<String, Object> bins;
    public final int generation;
    public final int expiration;

    public Record(Map<String, Object> bins, int generation, int expiration) {
        this.bins = bins;
        this.generation = generation;
        this.expiration = expiration;
    }

    public Object getValue(String name) {
        return this.bins == null ? null : this.bins.get(name);
    }

    public String getString(String name) {
        return (String)this.getValue(name);
    }

    public double getDouble(String name) {
        return Double.longBitsToDouble(this.getLong(name));
    }

    public float getFloat(String name) {
        return (float)Double.longBitsToDouble(this.getLong(name));
    }

    public long getLong(String name) {
        Object result = this.getValue(name);
        return result != null ? (Long)result : 0L;
    }

    public int getInt(String name) {
        return (int)this.getLong(name);
    }

    public short getShort(String name) {
        return (short)this.getLong(name);
    }

    public byte getByte(String name) {
        return (byte)this.getLong(name);
    }

    public boolean getBoolean(String name) {
        return this.getLong(name) != 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        sb.append("(gen:");
        sb.append(this.generation);
        sb.append("),(exp:");
        sb.append(this.expiration);
        sb.append("),(bins:");
        if (this.bins != null) {
            boolean sep = false;
            for (Map.Entry<String, Object> entry : this.bins.entrySet()) {
                if (sep) {
                    sb.append(',');
                } else {
                    sep = true;
                }
                sb.append('(');
                sb.append(entry.getKey());
                sb.append(':');
                sb.append(entry.getValue());
                sb.append(')');
                if (sb.length() <= 1000) continue;
                sb.append("...");
                break;
            }
        } else {
            sb.append("null");
        }
        sb.append(')');
        return sb.toString();
    }
}

