/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class ZooKeeperWatcher
implements Watcher,
Abortable {
    private static final Log LOG = LogFactory.getLog(ZooKeeperWatcher.class);
    private String prefix;
    private String identifier;
    private String quorum;
    private RecoverableZooKeeper recoverableZooKeeper;
    private Abortable abortable;
    private final List<ZooKeeperListener> listeners = new CopyOnWriteArrayList<ZooKeeperListener>();
    private Set<String> unassignedNodes = new HashSet<String>();
    public String baseZNode;
    public String rootServerZNode;
    public String rsZNode;
    public String drainingZNode;
    public String masterAddressZNode;
    public String backupMasterAddressesZNode;
    public String clusterStateZNode;
    public String assignmentZNode;
    public String masterTableZNode;
    public String clientTableZNode;
    public String masterTableZNode92;
    public String clusterIdZNode;
    public String splitLogZNode;
    public static final ArrayList<ACL> CREATOR_ALL_AND_WORLD_READABLE = new ArrayList<ACL>(){
        {
            this.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
            this.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
        }
    };
    private final Configuration conf;
    private final Exception constructorCaller;

    public ZooKeeperWatcher(Configuration conf, String descriptor, Abortable abortable) throws ZooKeeperConnectionException, IOException {
        this(conf, descriptor, abortable, false);
    }

    public ZooKeeperWatcher(Configuration conf, String descriptor, Abortable abortable, boolean canCreateBaseZNode) throws IOException, ZooKeeperConnectionException {
        this.conf = conf;
        try {
            throw new Exception("ZKW CONSTRUCTOR STACK TRACE FOR DEBUGGING");
        }
        catch (Exception e) {
            this.constructorCaller = e;
            this.quorum = ZKConfig.getZKQuorumServersString(conf);
            this.prefix = descriptor;
            this.identifier = descriptor + "0x0";
            this.abortable = abortable;
            this.setNodeNames(conf);
            this.recoverableZooKeeper = ZKUtil.connect(conf, this.quorum, this, descriptor);
            if (canCreateBaseZNode) {
                this.createBaseZNodes();
            }
            return;
        }
    }

    private void createBaseZNodes() throws ZooKeeperConnectionException {
        try {
            ZKUtil.createAndFailSilent(this, this.baseZNode);
            ZKUtil.createAndFailSilent(this, this.assignmentZNode);
            ZKUtil.createAndFailSilent(this, this.rsZNode);
            ZKUtil.createAndFailSilent(this, this.drainingZNode);
            ZKUtil.createAndFailSilent(this, this.masterTableZNode);
            ZKUtil.createAndFailSilent(this, this.masterTableZNode92);
            ZKUtil.createAndFailSilent(this, this.splitLogZNode);
            ZKUtil.createAndFailSilent(this, this.backupMasterAddressesZNode);
        }
        catch (KeeperException e) {
            throw new ZooKeeperConnectionException(this.prefix("Unexpected KeeperException creating base node"), (Exception)((Object)e));
        }
    }

    private boolean isFinishedRetryingRecoverable(long finished) {
        return System.currentTimeMillis() < finished;
    }

    public String toString() {
        return this.identifier;
    }

    public String prefix(String str) {
        return this.toString() + " " + str;
    }

    private void setNodeNames(Configuration conf) {
        this.baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        this.rootServerZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.rootserver", "root-region-server"));
        this.rsZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.rs", "rs"));
        this.drainingZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.draining.rs", "draining"));
        this.masterAddressZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.master", "master"));
        this.backupMasterAddressesZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.backup.masters", "backup-masters"));
        this.clusterStateZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.state", "shutdown"));
        this.assignmentZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.unassigned", "unassigned"));
        String tableZNodeDefault = "table";
        this.masterTableZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.masterTableEnableDisable", tableZNodeDefault));
        this.clientTableZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.clientTableEnableDisable", tableZNodeDefault));
        this.masterTableZNode92 = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.masterTableEnableDisable92", "table92"));
        this.clusterIdZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.clusterId", "hbaseid"));
        this.splitLogZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.splitlog", "splitlog"));
    }

    public void registerListener(ZooKeeperListener listener) {
        this.listeners.add(listener);
    }

    public void registerListenerFirst(ZooKeeperListener listener) {
        this.listeners.add(0, listener);
    }

    public void unregisterAllListeners() {
        this.listeners.clear();
    }

    public List<ZooKeeperListener> getListeners() {
        return new ArrayList<ZooKeeperListener>(this.listeners);
    }

    public int getNumberOfListeners() {
        return this.listeners.size();
    }

    public RecoverableZooKeeper getRecoverableZooKeeper() {
        return this.recoverableZooKeeper;
    }

    public void reconnectAfterExpiration() throws IOException, KeeperException, InterruptedException {
        this.recoverableZooKeeper.reconnectAfterExpiration();
    }

    public String getQuorum() {
        return this.quorum;
    }

    public void process(WatchedEvent event) {
        LOG.debug((Object)this.prefix("Received ZooKeeper Event, type=" + event.getType() + ", " + "state=" + event.getState() + ", " + "path=" + event.getPath()));
        switch (event.getType()) {
            case None: {
                this.connectionEvent(event);
                break;
            }
            case NodeCreated: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeCreated(event.getPath());
                }
                break;
            }
            case NodeDeleted: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDeleted(event.getPath());
                }
                break;
            }
            case NodeDataChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDataChanged(event.getPath());
                }
                break;
            }
            case NodeChildrenChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeChildrenChanged(event.getPath());
                }
                break;
            }
        }
    }

    private void connectionEvent(WatchedEvent event) {
        switch (event.getState()) {
            case SyncConnected: {
                long finished = System.currentTimeMillis() + this.conf.getLong("hbase.zookeeper.watcher.sync.connected.wait", 2000L);
                while (System.currentTimeMillis() < finished) {
                    Threads.sleep(1L);
                    if (this.recoverableZooKeeper == null) continue;
                }
                if (this.recoverableZooKeeper == null) {
                    LOG.error((Object)"ZK is null on connection event -- see stack trace for the stack trace when constructor was called on this zkw", (Throwable)this.constructorCaller);
                    throw new NullPointerException("ZK is null");
                }
                this.identifier = this.prefix + "-0x" + Long.toHexString(this.recoverableZooKeeper.getSessionId());
                LOG.debug((Object)(this.identifier + " connected"));
                break;
            }
            case Disconnected: {
                LOG.debug((Object)this.prefix("Received Disconnected from ZooKeeper, ignoring"));
                break;
            }
            case Expired: {
                String msg = this.prefix(this.identifier + " received expired from " + "ZooKeeper, aborting");
                if (this.abortable == null) break;
                this.abortable.abort(msg, (Throwable)new KeeperException.SessionExpiredException());
            }
        }
    }

    public void sync(String path) throws KeeperException {
        this.recoverableZooKeeper.sync(path, null, null);
    }

    public void keeperException(KeeperException ke) throws KeeperException {
        LOG.error((Object)this.prefix("Received unexpected KeeperException, re-throwing exception"), (Throwable)ke);
        throw ke;
    }

    public void interruptedException(InterruptedException ie) {
        LOG.debug((Object)this.prefix("Received InterruptedException, doing nothing here"), (Throwable)ie);
        Thread.currentThread().interrupt();
    }

    public void close() {
        try {
            if (this.recoverableZooKeeper != null) {
                this.recoverableZooKeeper.close();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void abort(String why, Throwable e) {
        this.abortable.abort(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.abortable.isAborted();
    }
}

