/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class RootRegionTracker
extends ZooKeeperNodeTracker {
    public RootRegionTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.rootServerZNode, abortable);
    }

    public boolean isLocationAvailable() {
        return super.getData(true) != null;
    }

    public ServerName getRootRegionLocation() throws InterruptedException {
        return RootRegionTracker.dataToServerName(super.getData(true));
    }

    public ServerName waitRootRegionLocation(long timeout) throws InterruptedException {
        if (!this.checkIfBaseNodeAvailable()) {
            String errorMsg = "Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
            LOG.error((Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        return RootRegionTracker.dataToServerName(super.blockUntilAvailable(timeout, true));
    }

    private static ServerName dataToServerName(byte[] data) {
        if (data == null || data.length <= 0) {
            return null;
        }
        String str = Bytes.toString(data);
        int index = str.indexOf(",");
        if (index != -1) {
            return ServerName.parseServerName(str);
        }
        String hostname = Addressing.parseHostname(str);
        int port = Addressing.parsePort(str);
        return new ServerName(hostname, port, -1L);
    }
}

