/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Stoppable;

public class Sleeper {
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private final int period;
    private final Stoppable stopper;
    private static final long MINIMAL_DELTA_FOR_LOGGING = 10000L;
    private final Object sleepLock = new Object();
    private boolean triggerWake = false;

    public Sleeper(int sleep, Stoppable stopper) {
        this.period = sleep;
        this.stopper = stopper;
    }

    public void sleep() {
        this.sleep(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipSleepCycle() {
        Object object = this.sleepLock;
        synchronized (object) {
            this.triggerWake = true;
            this.sleepLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long startTime) {
        if (this.stopper.isStopped()) {
            return;
        }
        long now = System.currentTimeMillis();
        long waitTime = (long)this.period - (now - startTime);
        if (waitTime > (long)this.period) {
            this.LOG.warn((Object)("Calculated wait time > " + this.period + "; setting to this.period: " + System.currentTimeMillis() + ", " + startTime));
            waitTime = this.period;
        }
        while (waitTime > 0L) {
            long woke;
            block10: {
                woke = -1L;
                try {
                    Object object = this.sleepLock;
                    synchronized (object) {
                        if (this.triggerWake) {
                            break;
                        }
                        this.sleepLock.wait(waitTime);
                    }
                    woke = System.currentTimeMillis();
                    long slept = woke - now;
                    if (slept - (long)this.period > 10000L) {
                        this.LOG.warn((Object)("We slept " + slept + "ms instead of " + this.period + "ms, this is likely due to a long " + "garbage collecting pause and it's usually bad, see " + "http://hbase.apache.org/book.html#trouble.rs.runtime.zkexpired"));
                    }
                }
                catch (InterruptedException iex) {
                    if (!this.stopper.isStopped()) break block10;
                    return;
                }
            }
            woke = woke == -1L ? System.currentTimeMillis() : woke;
            waitTime = (long)this.period - (woke - startTime);
        }
        this.triggerWake = false;
    }
}

