/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

public class MetaUtils {
    private static final Log LOG = LogFactory.getLog(MetaUtils.class);
    private final Configuration conf;
    private FileSystem fs;
    private HLog log;
    private HRegion rootRegion;
    private Map<byte[], HRegion> metaRegions = Collections.synchronizedSortedMap(new TreeMap(Bytes.BYTES_COMPARATOR));

    public MetaUtils() throws IOException {
        this(HBaseConfiguration.create());
    }

    public MetaUtils(Configuration conf) throws IOException {
        this.conf = conf;
        conf.setInt("hbase.client.retries.number", 1);
        this.rootRegion = null;
        this.initialize();
    }

    private void initialize() throws IOException {
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    public synchronized HLog getLog() throws IOException {
        if (this.log == null) {
            Path logdir = new Path(this.fs.getHomeDirectory(), ".logs_" + System.currentTimeMillis());
            Path oldLogDir = new Path(this.fs.getHomeDirectory(), ".oldlogs");
            this.log = new HLog(this.fs, logdir, oldLogDir, this.conf);
        }
        return this.log;
    }

    public HRegion getRootRegion() throws IOException {
        if (this.rootRegion == null) {
            this.openRootRegion();
        }
        return this.rootRegion;
    }

    public HRegion getMetaRegion(HRegionInfo metaInfo) throws IOException {
        HRegion meta = this.metaRegions.get(metaInfo.getRegionName());
        if (meta == null) {
            meta = this.openMetaRegion(metaInfo);
            LOG.info((Object)("OPENING META " + meta.toString()));
            this.metaRegions.put(metaInfo.getRegionName(), meta);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.rootRegion != null) {
            try {
                this.rootRegion.close();
            }
            catch (IOException e) {
                LOG.error((Object)"closing root region", (Throwable)e);
            }
            finally {
                this.rootRegion = null;
            }
        }
        try {
            for (HRegion r : this.metaRegions.values()) {
                LOG.info((Object)("CLOSING META " + r.toString()));
                r.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"closing meta region", (Throwable)e);
        }
        finally {
            this.metaRegions.clear();
        }
        try {
            if (this.log != null) {
                this.log.rollWriter();
                this.log.closeAndDelete();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"closing HLog", (Throwable)e);
        }
        finally {
            this.log = null;
        }
    }

    public void scanRootRegion(ScannerListener listener) throws IOException {
        if (this.rootRegion == null) {
            this.openRootRegion();
        }
        this.scanMetaRegion(this.rootRegion, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanMetaRegion(HRegion r, ScannerListener listener) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        RegionScanner s = r.getScanner(scan);
        try {
            ArrayList<KeyValue> results = new ArrayList<KeyValue>();
            boolean hasNext = true;
            do {
                hasNext = s.next(results);
                HRegionInfo info = null;
                for (KeyValue kv : results) {
                    info = Writables.getHRegionInfoOrNull(kv.getValue());
                    if (info != null) continue;
                    LOG.warn((Object)("Region info is null for row " + Bytes.toStringBinary(kv.getRow()) + " in table " + r.getTableDesc().getNameAsString()));
                }
                if (!listener.processRow(info)) {
                    break;
                }
                results.clear();
            } while (hasNext);
        }
        finally {
            s.close();
        }
    }

    public void scanMetaRegion(HRegionInfo metaRegionInfo, ScannerListener listener) throws IOException {
        HRegion metaRegion = this.openMetaRegion(metaRegionInfo);
        this.scanMetaRegion(metaRegion, listener);
    }

    private synchronized HRegion openRootRegion() throws IOException {
        if (this.rootRegion != null) {
            return this.rootRegion;
        }
        this.rootRegion = HRegion.openHRegion(HRegionInfo.ROOT_REGIONINFO, HTableDescriptor.ROOT_TABLEDESC, this.getLog(), this.conf);
        this.rootRegion.compactStores();
        return this.rootRegion;
    }

    private HRegion openMetaRegion(HRegionInfo metaInfo) throws IOException {
        HRegion meta = HRegion.openHRegion(metaInfo, HTableDescriptor.META_TABLEDESC, this.getLog(), this.conf);
        meta.compactStores();
        return meta;
    }

    public static void changeOnlineStatus(Configuration c, byte[] row, boolean onlineOffline) throws IOException {
        HTable t = new HTable(c, HConstants.META_TABLE_NAME);
        Get get2 = new Get(row);
        get2.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        Result res = t.get(get2);
        KeyValue[] kvs = res.raw();
        if (kvs.length <= 0) {
            throw new IOException("no information for row " + Bytes.toString(row));
        }
        byte[] value = kvs[0].getValue();
        if (value == null) {
            throw new IOException("no information for row " + Bytes.toString(row));
        }
        HRegionInfo info = Writables.getHRegionInfo(value);
        Put put2 = new Put(row);
        info.setOffline(onlineOffline);
        put2.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)info));
        t.put(put2);
        Delete delete = new Delete(row);
        delete.deleteColumns(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        delete.deleteColumns(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
        t.delete(delete);
    }

    public void updateMETARegionInfo(HRegion r, HRegionInfo hri) throws IOException {
        if (LOG.isDebugEnabled()) {
            Get get2 = new Get(hri.getRegionName());
            get2.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            Result res = r.get(get2, null);
            KeyValue[] kvs = res.raw();
            if (kvs.length <= 0) {
                return;
            }
            byte[] value = kvs[0].getValue();
            if (value == null) {
                return;
            }
            HRegionInfo h = Writables.getHRegionInfoOrNull(value);
            LOG.debug((Object)("Old " + Bytes.toString(HConstants.CATALOG_FAMILY) + ":" + Bytes.toString(HConstants.REGIONINFO_QUALIFIER) + " for " + hri.toString() + " in " + r.toString() + " is: " + h.toString()));
        }
        Put put2 = new Put(hri.getRegionName());
        put2.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
        r.put(put2);
        if (LOG.isDebugEnabled()) {
            Get get3 = new Get(hri.getRegionName());
            get3.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            Result res = r.get(get3, null);
            KeyValue[] kvs = res.raw();
            if (kvs.length <= 0) {
                return;
            }
            byte[] value = kvs[0].getValue();
            if (value == null) {
                return;
            }
            HRegionInfo h = Writables.getHRegionInfoOrNull(value);
            LOG.debug((Object)("New " + Bytes.toString(HConstants.CATALOG_FAMILY) + ":" + Bytes.toString(HConstants.REGIONINFO_QUALIFIER) + " for " + hri.toString() + " in " + r.toString() + " is: " + h.toString()));
        }
    }

    public List<HRegionInfo> getMETARows(byte[] tableName) throws IOException {
        final ArrayList<HRegionInfo> result = new ArrayList<HRegionInfo>();
        if (Bytes.equals(HConstants.META_TABLE_NAME, tableName)) {
            result.add(this.openRootRegion().getRegionInfo());
            return result;
        }
        this.scanRootRegion(new ScannerListener(){
            private final Log SL_LOG = LogFactory.getLog(this.getClass());

            @Override
            public boolean processRow(HRegionInfo info) throws IOException {
                this.SL_LOG.debug((Object)("Testing " + (Object)((Object)info)));
                if (Bytes.equals(info.getTableName(), HConstants.META_TABLE_NAME)) {
                    result.add(info);
                    return false;
                }
                return true;
            }
        });
        return result;
    }

    public static interface ScannerListener {
        public boolean processRow(HRegionInfo var1) throws IOException;
    }
}

