/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.zookeeper.KeeperException;

public class HBaseFsckRepair {
    public static final Log LOG = LogFactory.getLog(HBaseFsckRepair.class);

    public static void fixMultiAssignment(HBaseAdmin admin, HRegionInfo region, List<ServerName> servers) throws IOException, KeeperException, InterruptedException {
        HRegionInfo actualRegion = new HRegionInfo(region);
        for (ServerName server : servers) {
            HBaseFsckRepair.closeRegionSilentlyAndWait(admin, server, actualRegion);
        }
        HBaseFsckRepair.forceOfflineInZK(admin, actualRegion);
    }

    public static void fixUnassigned(HBaseAdmin admin, HRegionInfo region) throws IOException, KeeperException {
        HRegionInfo actualRegion = new HRegionInfo(region);
        HBaseFsckRepair.forceOfflineInZK(admin, actualRegion);
    }

    private static void forceOfflineInZK(HBaseAdmin admin, HRegionInfo region) throws ZooKeeperConnectionException, KeeperException, IOException {
        admin.assign(region.getRegionName());
    }

    public static void waitUntilAssigned(HBaseAdmin admin, HRegionInfo region) throws IOException, InterruptedException {
        long timeout = admin.getConfiguration().getLong("hbase.hbck.assign.timeout", 120000L);
        long expiration = timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expiration) {
            try {
                Map<String, AssignmentManager.RegionState> rits = admin.getClusterStatus().getRegionsInTransition();
                if (rits.keySet() != null && !rits.keySet().contains(region.getEncodedName())) {
                    return;
                }
                LOG.info((Object)("Region still in transition, waiting for it to become assigned: " + (Object)((Object)region)));
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception when waiting for region to become assigned, retrying", (Throwable)e);
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + (Object)((Object)region) + " failed to move out of " + "transition within timeout " + timeout + "ms");
    }

    public static void closeRegionSilentlyAndWait(HBaseAdmin admin, ServerName server, HRegionInfo region) throws IOException, InterruptedException {
        HConnection connection = admin.getConnection();
        HRegionInterface rs = connection.getHRegionConnection(server.getHostname(), server.getPort());
        try {
            rs.closeRegion(region, false);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Exception when closing region: " + region.getRegionNameAsString()), (Throwable)ioe);
        }
        long timeout = admin.getConfiguration().getLong("hbase.hbck.close.timeout", 120000L);
        long expiration = timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expiration) {
            try {
                HRegionInfo rsRegion = rs.getRegionInfo(region.getRegionName());
                if (rsRegion == null) {
                    return;
                }
            }
            catch (IOException ioe) {
                return;
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + (Object)((Object)region) + " failed to close within" + " timeout " + timeout);
    }

    public static void fixMetaHoleOnline(Configuration conf, HRegionInfo hri) throws IOException {
        Put p = new Put(hri.getRegionName());
        p.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
        HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
        meta.put(p);
        meta.close();
    }

    public static HRegion createHDFSRegionDir(Configuration conf, HRegionInfo hri, HTableDescriptor htd) throws IOException {
        Path root = FSUtils.getRootDir(conf);
        HRegion region = HRegion.createHRegion(hri, root, conf, htd);
        HLog hlog = region.getLog();
        region.close();
        hlog.closeAndDelete();
        return region;
    }
}

