/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.constant.Constable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.apache.hadoop.io.WritableFactories;

public class Classes {
    private static final ClassLoader CLASS_LOADER;

    public static Class<?> extendedForName(String className) throws ClassNotFoundException {
        Class<Constable> valueType = className.equals("boolean") ? Boolean.TYPE : (className.equals("byte") ? Byte.TYPE : (className.equals("short") ? Short.TYPE : (className.equals("int") ? Integer.TYPE : (className.equals("long") ? Long.TYPE : (className.equals("float") ? Float.TYPE : (className.equals("double") ? Double.TYPE : (className.equals("char") ? Character.TYPE : Class.forName(className))))))));
        return valueType;
    }

    public static String stringify(Class[] classes) {
        StringBuilder buf = new StringBuilder();
        if (classes != null) {
            for (Class c : classes) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(c.getName());
            }
        } else {
            buf.append("NULL");
        }
        return buf.toString();
    }

    public static Class<? extends Filter> getFilterClassByName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, CLASS_LOADER);
    }

    public static Filter createWritableForName(String className) {
        try {
            Class<? extends Filter> clazz = Classes.getFilterClassByName(className);
            return (Filter)WritableFactories.newInstance(clazz, (Configuration)new Configuration());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class " + className);
        }
    }

    public static Filter createForName(String className) {
        try {
            Class<? extends Filter> clazz = Classes.getFilterClassByName(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class " + className);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Couldn't instantiate " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No access to " + className, e);
        }
    }

    static {
        ClassLoader parent = Classes.class.getClassLoader();
        Configuration conf = HBaseConfiguration.create();
        CLASS_LOADER = new DynamicClassLoader(conf, parent);
    }
}

