/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HThreadedSelectorServerArgs
extends TThreadedSelectorServer.Args {
    private static final Logger LOG = LoggerFactory.getLogger(TThreadedSelectorServer.class);
    public static final String SELECTOR_THREADS_CONF_KEY = "hbase.thrift.selector.threads";
    public static final String WORKER_THREADS_CONF_KEY = "hbase.thrift.worker.threads";
    public static final String STOP_TIMEOUT_CONF_KEY = "hbase.thrift.stop.timeout.seconds";
    public static final String ACCEPT_QUEUE_SIZE_PER_THREAD_CONF_KEY = "hbase.thrift.accept.queue.size.per.selector";
    public static final String ACCEPT_POLICY_CONF_KEY = "hbase.thrift.accept.policy";

    public HThreadedSelectorServerArgs(TNonblockingServerTransport transport, Configuration conf) {
        super(transport);
        this.readConf(conf);
    }

    private void readConf(Configuration conf) {
        int selectorThreads = conf.getInt(SELECTOR_THREADS_CONF_KEY, this.getSelectorThreads());
        int workerThreads = conf.getInt(WORKER_THREADS_CONF_KEY, this.getWorkerThreads());
        int stopTimeoutVal = conf.getInt(STOP_TIMEOUT_CONF_KEY, this.getStopTimeoutVal());
        int acceptQueueSizePerThread = conf.getInt(ACCEPT_QUEUE_SIZE_PER_THREAD_CONF_KEY, this.getAcceptQueueSizePerThread());
        TThreadedSelectorServer.Args.AcceptPolicy acceptPolicy = TThreadedSelectorServer.Args.AcceptPolicy.valueOf((String)conf.get(ACCEPT_POLICY_CONF_KEY, this.getAcceptPolicy().toString()).toUpperCase());
        super.selectorThreads(selectorThreads).workerThreads(workerThreads).stopTimeoutVal(stopTimeoutVal).acceptQueueSizePerThread(acceptQueueSizePerThread).acceptPolicy(acceptPolicy);
        LOG.info("Read configuration selectorThreads:" + selectorThreads + " workerThreads:" + workerThreads + " stopTimeoutVal:" + stopTimeoutVal + "sec" + " acceptQueueSizePerThread:" + acceptQueueSizePerThread + " acceptPolicy:" + acceptPolicy);
    }
}

