/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotTask;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TableInfoCopyTask
extends SnapshotTask {
    public static final Log LOG = LogFactory.getLog(TableInfoCopyTask.class);
    private final FileSystem fs;
    private final Path rootDir;

    public TableInfoCopyTask(ForeignExceptionDispatcher monitor, HBaseProtos.SnapshotDescription snapshot, FileSystem fs, Path rootDir) {
        super(snapshot, monitor);
        this.rootDir = rootDir;
        this.fs = fs;
    }

    @Override
    public Void call() throws Exception {
        LOG.debug((Object)"Running table info copy.");
        this.rethrowException();
        LOG.debug((Object)("Attempting to copy table info for snapshot:" + SnapshotDescriptionUtils.toString(this.snapshot)));
        HTableDescriptor orig = FSTableDescriptors.getTableDescriptor(this.fs, this.rootDir, Bytes.toBytes(this.snapshot.getTable()));
        this.rethrowException();
        Path snapshotDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(this.snapshot, this.rootDir);
        FSTableDescriptors.createTableDescriptorForTableDirectory(this.fs, snapshotDir, orig, false);
        LOG.debug((Object)"Finished copying tableinfo.");
        return null;
    }
}

