/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ZKPermissionWatcher
extends ZooKeeperListener {
    private static Log LOG = LogFactory.getLog(ZKPermissionWatcher.class);
    static final String ACL_NODE = "acl";
    TableAuthManager authManager;
    String aclZNode;

    public ZKPermissionWatcher(ZooKeeperWatcher watcher, TableAuthManager authManager, Configuration conf) {
        super(watcher);
        this.authManager = authManager;
        String aclZnodeParent = conf.get("zookeeper.znode.acl.parent", ACL_NODE);
        this.aclZNode = ZKUtil.joinZNode(watcher.baseZNode, aclZnodeParent);
    }

    public void start() throws KeeperException {
        List<ZKUtil.NodeAndData> existing;
        this.watcher.registerListener(this);
        if (ZKUtil.watchAndCheckExists(this.watcher, this.aclZNode) && (existing = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.aclZNode)) != null) {
            this.refreshNodes(existing);
        }
    }

    @Override
    public void nodeCreated(String path) {
        if (path.equals(this.aclZNode)) {
            try {
                List<ZKUtil.NodeAndData> nodes = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.aclZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.error((Object)"Error reading data from zookeeper", (Throwable)ke);
                this.watcher.abort("Zookeeper error obtaining acl node children", ke);
            }
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (this.aclZNode.equals(ZKUtil.getParent(path))) {
            String table = ZKUtil.getNodeName(path);
            this.authManager.remove(Bytes.toBytes(table));
        }
    }

    @Override
    public void nodeDataChanged(String path) {
        if (this.aclZNode.equals(ZKUtil.getParent(path))) {
            String table = ZKUtil.getNodeName(path);
            try {
                byte[] data = ZKUtil.getDataAndWatch(this.watcher, path);
                this.authManager.refreshCacheFromWritable(Bytes.toBytes(table), data);
            }
            catch (KeeperException ke) {
                LOG.error((Object)("Error reading data from zookeeper for node " + table), (Throwable)ke);
                this.watcher.abort("Zookeeper error getting data for node " + table, ke);
            }
            catch (IOException ioe) {
                LOG.error((Object)"Error reading permissions writables", (Throwable)ioe);
            }
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.aclZNode)) {
            try {
                List<ZKUtil.NodeAndData> nodes = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.aclZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.error((Object)("Error reading data from zookeeper for path " + path), (Throwable)ke);
                this.watcher.abort("Zookeeper error get node children for path " + path, ke);
            }
        }
    }

    private void refreshNodes(List<ZKUtil.NodeAndData> nodes) {
        for (ZKUtil.NodeAndData n : nodes) {
            if (n.isEmpty()) continue;
            String path = n.getNode();
            String table = ZKUtil.getNodeName(path);
            try {
                byte[] nodeData = n.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Updating permissions cache from node " + table + " with data: " + Bytes.toStringBinary(nodeData)));
                }
                this.authManager.refreshCacheFromWritable(Bytes.toBytes(table), nodeData);
            }
            catch (IOException ioe) {
                LOG.error((Object)("Failed parsing permissions for table '" + table + "' from zk"), (Throwable)ioe);
            }
        }
    }

    public void writeToZookeeper(byte[] tableName, byte[] parmsData) {
        String zkNode = ZKUtil.joinZNode(this.watcher.baseZNode, ACL_NODE);
        zkNode = ZKUtil.joinZNode(zkNode, Bytes.toString(tableName));
        try {
            ZKUtil.createWithParents(this.watcher, zkNode);
            ZKUtil.updateExistingNodeData(this.watcher, zkNode, parmsData, -1);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed updating permissions for table '" + Bytes.toString(tableName) + "'"), (Throwable)e);
            this.watcher.abort("Failed writing node " + zkNode + " to zookeeper", e);
        }
    }

    public void deleteTableACLNode(byte[] tableName) {
        String zkNode = ZKUtil.joinZNode(this.watcher.baseZNode, ACL_NODE);
        zkNode = ZKUtil.joinZNode(zkNode, Bytes.toString(tableName));
        try {
            ZKUtil.deleteNode(this.watcher, zkNode);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn((Object)("No acl notify node of table '" + tableName + "'"));
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed deleting acl node of table '" + tableName + "'"), (Throwable)e);
            this.watcher.abort("Failed deleting node " + zkNode, e);
        }
    }
}

