/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.Decoder;
import org.apache.hadoop.hbase.codec.Encoder;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.KeyValueCompression;

public class WALEditCodec
implements Codec {
    public static final String WAL_EDIT_CODEC_CLASS_KEY = "hbase.regionserver.wal.codec";
    private CompressionContext compression;

    public void init(Configuration conf) {
    }

    public void setCompression(CompressionContext compression) {
        this.compression = compression;
    }

    @Override
    public Decoder getDecoder(InputStream is) {
        return this.compression == null ? new KeyValueCodec.KeyValueDecoder((DataInputStream)is) : new KeyValueCompression.CompressedKvDecoder((DataInputStream)is, this.compression);
    }

    @Override
    public Encoder getEncoder(OutputStream os) {
        return this.compression == null ? new KeyValueCodec.KeyValueEncoder((DataOutputStream)os) : new KeyValueCompression.CompressedKvEncoder((DataOutputStream)os, this.compression);
    }

    public static WALEditCodec create(Configuration conf, CompressionContext compressionContext) throws IOException {
        Class codecClazz = conf.getClass(WAL_EDIT_CODEC_CLASS_KEY, WALEditCodec.class, WALEditCodec.class);
        try {
            WALEditCodec codec = (WALEditCodec)codecClazz.newInstance();
            codec.init(conf);
            codec.setCompression(compressionContext);
            return codec;
        }
        catch (InstantiationException e) {
            throw new IOException("Couldn't instantiate the configured WALEditCodec!", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Couldn't instantiate the configured WALEditCodec!", e);
        }
    }
}

