/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.regionserver.metrics.RegionMetricsStorage;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.Bytes;

public class OperationMetrics {
    private static final String DELETE_KEY = "delete_";
    private static final String PUT_KEY = "put_";
    private static final String GET_KEY = "get_";
    private static final String ICV_KEY = "incrementColumnValue_";
    private static final String INCREMENT_KEY = "increment_";
    private static final String MULTIPUT_KEY = "multiput_";
    private static final String MULTIDELETE_KEY = "multidelete_";
    private static final String APPEND_KEY = "append_";
    private static final String READREQUESTCOUNT_KEY = "readrequestcount";
    private static final String WRITEREQUESTCOUNT_KEY = "writerequestcount";
    private static final String CONF_KEY = "hbase.metrics.exposeOperationTimes";
    private final String tableName;
    private final String regionName;
    private final String regionMetrixPrefix;
    private final Configuration conf;
    private final boolean exposeTimes;

    public OperationMetrics(Configuration conf, HRegionInfo regionInfo) {
        if (conf != null) {
            SchemaMetrics.configureGlobally(conf);
            this.conf = conf;
            if (regionInfo != null) {
                this.tableName = regionInfo.getTableNameAsString();
                this.regionName = regionInfo.getEncodedName();
            } else {
                this.tableName = "__unknown";
                this.regionName = "__unknown";
            }
            this.regionMetrixPrefix = SchemaMetrics.generateRegionMetricsPrefix(this.tableName, this.regionName);
            this.exposeTimes = this.conf.getBoolean(CONF_KEY, true);
        } else {
            this.conf = null;
            this.tableName = null;
            this.regionName = null;
            this.regionMetrixPrefix = null;
            this.exposeTimes = false;
        }
    }

    public OperationMetrics() {
        this(null, null);
    }

    public void setReadRequestCountMetrics(long value) {
        this.doSetNumericPersistentMetrics(READREQUESTCOUNT_KEY, value);
    }

    public void setWriteRequestCountMetrics(long value) {
        this.doSetNumericPersistentMetrics(WRITEREQUESTCOUNT_KEY, value);
    }

    private void doSetNumericPersistentMetrics(String key, long value) {
        RegionMetricsStorage.setNumericPersistentMetric(this.regionMetrixPrefix + key, value);
    }

    public void updateMultiPutMetrics(Set<byte[]> columnFamilies, long value) {
        this.doUpdateTimeVarying(columnFamilies, MULTIPUT_KEY, value);
    }

    public void updateMultiDeleteMetrics(Set<byte[]> columnFamilies, long value) {
        this.doUpdateTimeVarying(columnFamilies, MULTIDELETE_KEY, value);
    }

    public void updateGetMetrics(Set<byte[]> columnFamilies, long value) {
        this.doUpdateTimeVarying(columnFamilies, GET_KEY, value);
    }

    public void updateIncrementMetrics(Set<byte[]> columnFamilies, long value) {
        this.doUpdateTimeVarying(columnFamilies, INCREMENT_KEY, value);
    }

    public void updateAppendMetrics(Set<byte[]> columnFamilies, long value) {
        this.doUpdateTimeVarying(columnFamilies, APPEND_KEY, value);
    }

    public void updateIncrementColumnValueMetrics(byte[] columnFamily, long value) {
        String cfMetricPrefix = SchemaMetrics.generateSchemaMetricsPrefix(this.tableName, Bytes.toString(columnFamily));
        this.doSafeIncTimeVarying(cfMetricPrefix, ICV_KEY, value);
        this.doSafeIncTimeVarying(this.regionMetrixPrefix, ICV_KEY, value);
    }

    public void updatePutMetrics(Set<byte[]> columnFamilies, long value) {
        this.doUpdateTimeVarying(columnFamilies, PUT_KEY, value);
    }

    public void updateDeleteMetrics(Set<byte[]> columnFamilies, long value) {
        this.doUpdateTimeVarying(columnFamilies, DELETE_KEY, value);
    }

    public void closeMetrics(String regionEncodedName) {
        RegionMetricsStorage.clear(regionEncodedName);
    }

    private void doUpdateTimeVarying(Set<byte[]> columnFamilies, String key, long value) {
        String cfPrefix = null;
        cfPrefix = columnFamilies != null ? SchemaMetrics.generateSchemaMetricsPrefix(this.tableName, columnFamilies) : SchemaMetrics.generateSchemaMetricsPrefix(this.tableName, "__unknown");
        this.doSafeIncTimeVarying(cfPrefix, key, value);
        this.doSafeIncTimeVarying(this.regionMetrixPrefix, key, value);
    }

    private void doSafeIncTimeVarying(String prefix, String key, long value) {
        if (this.exposeTimes && prefix != null && !prefix.isEmpty() && key != null && !key.isEmpty()) {
            String m = prefix + key;
            RegionMetricsStorage.incrTimeVaryingMetric(m, value);
        }
    }
}

