/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.hbase.KeyValue;

public class KeyValueSkipListSet
implements NavigableSet<KeyValue> {
    private final ConcurrentNavigableMap<KeyValue, KeyValue> delegatee;

    KeyValueSkipListSet(KeyValue.KVComparator c) {
        this.delegatee = new ConcurrentSkipListMap<KeyValue, KeyValue>(c);
    }

    KeyValueSkipListSet(ConcurrentNavigableMap<KeyValue, KeyValue> m) {
        this.delegatee = m;
    }

    @Override
    public KeyValue ceiling(KeyValue e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<KeyValue> descendingIterator() {
        return this.delegatee.descendingMap().values().iterator();
    }

    @Override
    public NavigableSet<KeyValue> descendingSet() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public KeyValue floor(KeyValue e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SortedSet<KeyValue> headSet(KeyValue toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public NavigableSet<KeyValue> headSet(KeyValue toElement, boolean inclusive) {
        return new KeyValueSkipListSet((ConcurrentNavigableMap<KeyValue, KeyValue>)this.delegatee.headMap((Object)toElement, inclusive));
    }

    @Override
    public KeyValue higher(KeyValue e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<KeyValue> iterator() {
        return this.delegatee.values().iterator();
    }

    @Override
    public KeyValue lower(KeyValue e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public KeyValue pollFirst() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public KeyValue pollLast() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SortedSet<KeyValue> subSet(KeyValue fromElement, KeyValue toElement) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public NavigableSet<KeyValue> subSet(KeyValue fromElement, boolean fromInclusive, KeyValue toElement, boolean toInclusive) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SortedSet<KeyValue> tailSet(KeyValue fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public NavigableSet<KeyValue> tailSet(KeyValue fromElement, boolean inclusive) {
        return new KeyValueSkipListSet((ConcurrentNavigableMap<KeyValue, KeyValue>)this.delegatee.tailMap((Object)fromElement, inclusive));
    }

    @Override
    public Comparator<? super KeyValue> comparator() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public KeyValue first() {
        return (KeyValue)this.delegatee.get(this.delegatee.firstKey());
    }

    @Override
    public KeyValue last() {
        return (KeyValue)this.delegatee.get(this.delegatee.lastKey());
    }

    @Override
    public boolean add(KeyValue e) {
        return this.delegatee.put(e, e) == null;
    }

    @Override
    public boolean addAll(Collection<? extends KeyValue> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void clear() {
        this.delegatee.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegatee.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isEmpty() {
        return this.delegatee.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.delegatee.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public KeyValue get(KeyValue kv) {
        return (KeyValue)this.delegatee.get(kv);
    }

    @Override
    public int size() {
        return this.delegatee.size();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

