/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;

public class TableAddFamilyHandler
extends TableEventHandler {
    private final HColumnDescriptor familyDesc;

    public TableAddFamilyHandler(byte[] tableName, HColumnDescriptor familyDesc, Server server, MasterServices masterServices) throws IOException {
        super(EventHandler.EventType.C_M_ADD_FAMILY, tableName, server, masterServices);
        HTableDescriptor htd = this.getTableDescriptor();
        if (htd.hasFamily(familyDesc.getName())) {
            throw new InvalidFamilyOperationException("Family '" + familyDesc.getNameAsString() + "' already exists so cannot be added");
        }
        this.familyDesc = familyDesc;
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        this.masterServices.getMasterFileSystem().addColumn(this.tableName, this.familyDesc);
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        String family = "UnknownFamily";
        if (this.familyDesc != null) {
            family = this.familyDesc.getNameAsString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableNameStr + "-" + family;
    }
}

