/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MXBean;

public class MXBeanImpl
implements MXBean {
    private final HMaster master;
    private static MXBeanImpl instance = null;

    public static synchronized MXBeanImpl init(HMaster master) {
        if (instance == null) {
            instance = new MXBeanImpl(master);
        }
        return instance;
    }

    protected MXBeanImpl(HMaster master) {
        this.master = master;
    }

    @Override
    public double getAverageLoad() {
        return this.master.getAverageLoad();
    }

    @Override
    public String getClusterId() {
        return this.master.getClusterId();
    }

    @Override
    public String getZookeeperQuorum() {
        return this.master.getZooKeeperWatcher().getQuorum();
    }

    @Override
    public String[] getCoprocessors() {
        return this.master.getCoprocessors();
    }

    @Override
    public long getMasterStartTime() {
        return this.master.getMasterStartTime();
    }

    @Override
    public long getMasterActiveTime() {
        return this.master.getMasterActiveTime();
    }

    @Override
    public Map<String, HServerLoad> getRegionServers() {
        HashMap<String, HServerLoad> data = new HashMap<String, HServerLoad>();
        for (Map.Entry<ServerName, HServerLoad> entry : this.master.getServerManager().getOnlineServers().entrySet()) {
            data.put(entry.getKey().getServerName(), entry.getValue());
        }
        return data;
    }

    @Override
    public String[] getDeadRegionServers() {
        ArrayList<String> deadServers = new ArrayList<String>();
        for (ServerName name : this.master.getServerManager().getDeadServers()) {
            deadServers.add(name.getHostAndPort());
        }
        return deadServers.toArray(new String[0]);
    }

    @Override
    public MXBean.RegionsInTransitionInfo[] getRegionsInTransition() {
        ArrayList<1> info = new ArrayList<1>();
        for (final Map.Entry entry : this.master.getAssignmentManager().getRegionsInTransition().entrySet()) {
            MXBean.RegionsInTransitionInfo innerinfo = new MXBean.RegionsInTransitionInfo(){

                @Override
                public String getRegionState() {
                    return ((AssignmentManager.RegionState)entry.getValue()).getState().toString();
                }

                @Override
                public String getRegionName() {
                    return (String)entry.getKey();
                }

                @Override
                public long getLastUpdateTime() {
                    return ((AssignmentManager.RegionState)entry.getValue()).getStamp();
                }

                @Override
                public String getRegionServerName() {
                    ServerName serverName = ((AssignmentManager.RegionState)entry.getValue()).getServerName();
                    if (serverName != null) {
                        return serverName.getServerName();
                    }
                    return "";
                }
            };
            info.add(innerinfo);
        }
        MXBean.RegionsInTransitionInfo[] data = new MXBean.RegionsInTransitionInfo[info.size()];
        info.toArray(data);
        return data;
    }

    @Override
    public String getServerName() {
        return this.master.getServerName().getServerName();
    }

    @Override
    public boolean getIsActiveMaster() {
        return this.master.isActiveMaster();
    }
}

