/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Classes;

public class SkipFilter
extends FilterBase {
    private boolean filterRow = false;
    private Filter filter;

    public SkipFilter() {
    }

    public SkipFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void reset() {
        this.filter.reset();
        this.filterRow = false;
    }

    private void changeFR(boolean value) {
        this.filterRow = this.filterRow || value;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        Filter.ReturnCode c = this.filter.filterKeyValue(v);
        this.changeFR(c != Filter.ReturnCode.INCLUDE);
        return c;
    }

    @Override
    public KeyValue transform(KeyValue v) {
        return this.filter.transform(v);
    }

    @Override
    public boolean filterRow() {
        return this.filterRow;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.filter.getClass().getName());
        this.filter.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.filter = Classes.createForName(in.readUTF());
        this.filter.readFields(in);
    }

    @Override
    public boolean isFamilyEssential(byte[] name) {
        return FilterBase.isFamilyEssential(this.filter, name);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.filter.toString();
    }
}

