/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;

public class BitComparator
extends WritableByteArrayComparable {
    protected BitwiseOp bitOperator;

    public BitComparator() {
    }

    public BitComparator(byte[] value, BitwiseOp bitOperator) {
        super(value);
        this.bitOperator = bitOperator;
    }

    public BitwiseOp getOperator() {
        return this.bitOperator;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.bitOperator = BitwiseOp.valueOf(in.readUTF());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.bitOperator.name());
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        if (length != this.value.length) {
            return 1;
        }
        int b = 0;
        block5: for (int i = length - 1; i >= 0 && b == 0; --i) {
            switch (this.bitOperator) {
                case AND: {
                    b = this.value[i] & value[i + offset] & 0xFF;
                    continue block5;
                }
                case OR: {
                    b = (this.value[i] | value[i + offset]) & 0xFF;
                    continue block5;
                }
                case XOR: {
                    b = (this.value[i] ^ value[i + offset]) & 0xFF;
                }
            }
        }
        return b == 0 ? 1 : 0;
    }

    public static enum BitwiseOp {
        AND,
        OR,
        XOR;

    }
}

