/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class RootLocationEditor {
    private static final Log LOG = LogFactory.getLog(RootLocationEditor.class);

    public static void deleteRootLocation(ZooKeeperWatcher zookeeper) throws KeeperException {
        LOG.info((Object)"Unsetting ROOT region location in ZooKeeper");
        try {
            ZKUtil.deleteNode(zookeeper, zookeeper.rootServerZNode);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public static void setRootLocation(ZooKeeperWatcher zookeeper, ServerName location) throws KeeperException {
        LOG.info((Object)("Setting ROOT region location in ZooKeeper as " + location));
        try {
            ZKUtil.createAndWatch(zookeeper, zookeeper.rootServerZNode, Bytes.toBytes(location.toString()));
        }
        catch (KeeperException.NodeExistsException nee) {
            LOG.debug((Object)"ROOT region location already existed, updated location");
            ZKUtil.setData(zookeeper, zookeeper.rootServerZNode, Bytes.toBytes(location.toString()));
        }
    }
}

