/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import redis.clients.jedis.Builder;
import redis.clients.jedis.exceptions.JedisDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response<T> {
    protected T response = null;
    private boolean built = false;
    private boolean set = false;
    private Builder<T> builder;
    private Object data;

    public Response(Builder<T> b) {
        this.builder = b;
    }

    public void set(Object data) {
        this.data = data;
        this.set = true;
    }

    public T get() {
        if (!this.set) {
            throw new JedisDataException("Please close pipeline or multi block before calling this method.");
        }
        if (!this.built) {
            this.response = this.builder.build(this.data);
            this.data = null;
            this.built = true;
        }
        return this.response;
    }

    public String toString() {
        return "Response " + this.builder.toString();
    }
}

