/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.instrumentation.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.openjpa.instrumentation.jmx.JMXInstrument;
import org.apache.openjpa.lib.instrumentation.AbstractInstrumentationProvider;
import org.apache.openjpa.lib.instrumentation.Instrument;
import org.apache.openjpa.util.UserException;

public class JMXProvider
extends AbstractInstrumentationProvider {
    public static final String[] JMX_INSTRUMENT_ALIASES = new String[]{"DataCache", "org.apache.openjpa.instrumentation.jmx.DataCacheJMXInstrument", "QueryCache", "org.apache.openjpa.instrumentation.jmx.QueryCacheJMXInstrument", "QuerySQLCache", "org.apache.openjpa.instrumentation.jmx.PreparedQueryCacheJMXInstrument"};
    public static final String MBEAN_DOMAIN = "org.apache.openjpa";
    private Set<MBeanServer> _mbs = null;

    protected void registerMBean(JMXInstrument mBean) {
        Set<MBeanServer> mbs = this.getMBeanServer();
        try {
            for (MBeanServer s : mbs) {
                s.registerMBean(mBean, mBean.getObjectName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<MBeanServer> getMBeanServer() {
        if (this._mbs == null) {
            this._mbs = new HashSet<MBeanServer>();
            this._mbs.addAll(MBeanServerFactory.findMBeanServer(null));
            this._mbs.add(ManagementFactory.getPlatformMBeanServer());
        }
        return this._mbs;
    }

    public void start() {
        Set<MBeanServer> mbs = this.getMBeanServer();
        try {
            for (MBeanServer s : mbs) {
                if (mbs != null && mbs.size() != 0) continue;
                throw new UserException("jmx-server-failed-creation");
            }
            this.setStarted(true);
        }
        catch (Throwable t) {
            throw new UserException("jmx-server-unavailable", t);
        }
    }

    public void stop() {
        if (this.isStarted()) {
            Set instruments = this.getInstruments();
            if (instruments != null && instruments.size() > 0) {
                for (Instrument inst : instruments) {
                    this.stopInstrument(inst);
                }
            }
            this.setStarted(false);
        }
    }

    public static ObjectName createObjectName(JMXInstrument instrument, Map<String, String> props) throws Exception {
        StringBuilder sbName = new StringBuilder(MBEAN_DOMAIN);
        sbName.append(":type=");
        sbName.append(instrument.getName());
        sbName.append(",cfgid=");
        sbName.append(instrument.getConfigId());
        sbName.append(",cfgref=");
        sbName.append(instrument.getContextRef());
        if (props != null && !props.isEmpty()) {
            for (Map.Entry<String, String> prop : props.entrySet()) {
                sbName.append(",");
                sbName.append(prop.getKey());
                sbName.append("=");
                sbName.append(prop.getValue());
            }
        }
        return new ObjectName(sbName.toString());
    }

    public void startInstrument(Instrument instrument) {
        if (!instrument.isStarted()) {
            this.registerMBean((JMXInstrument)instrument);
            instrument.setStarted(true);
        }
    }

    public void stopInstrument(Instrument instrument, boolean force) {
        block4: {
            if (instrument.isStarted() || force) {
                Set<MBeanServer> mbs = this.getMBeanServer();
                try {
                    for (MBeanServer s : mbs) {
                        s.unregisterMBean(((JMXInstrument)instrument).getObjectName());
                    }
                    instrument.setStarted(false);
                }
                catch (Exception e) {
                    if (force) break block4;
                    throw new UserException("cannot-stop-instrument", (Throwable)e);
                }
            }
        }
    }

    public String[] getInstrumentAliases() {
        return JMX_INSTRUMENT_ALIASES;
    }
}

