/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.types.StructIterator;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Struct
implements DataType<Object[]> {
    protected final DataType[] fields;
    protected final boolean isOrderPreserving;
    protected final boolean isSkippable;

    public Struct(DataType[] memberTypes) {
        this.fields = memberTypes;
        boolean preservesOrder = true;
        boolean skippable = true;
        for (int i = 0; i < this.fields.length; ++i) {
            DataType dt = this.fields[i];
            if (!dt.isOrderPreserving()) {
                preservesOrder = false;
            }
            if (i < this.fields.length - 2 && !dt.isSkippable()) {
                throw new IllegalArgumentException("Field in position " + i + " is not skippable. Non-right-most struct fields must be skippable.");
            }
            if (dt.isSkippable()) continue;
            skippable = false;
        }
        this.isOrderPreserving = preservesOrder;
        this.isSkippable = skippable;
    }

    @Override
    public boolean isOrderPreserving() {
        return this.isOrderPreserving;
    }

    @Override
    public Order getOrder() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSkippable() {
        return this.isSkippable;
    }

    @Override
    public int encodedLength(Object[] val) {
        assert (this.fields.length >= val.length);
        int sum = 0;
        for (int i = 0; i < val.length; ++i) {
            sum += this.fields[i].encodedLength(val[i]);
        }
        return sum;
    }

    @Override
    public Class<Object[]> encodedClass() {
        return Object[].class;
    }

    public StructIterator iterator(PositionedByteRange src) {
        return new StructIterator(src, this.fields);
    }

    @Override
    public int skip(PositionedByteRange src) {
        StructIterator it = this.iterator(src);
        int skipped = 0;
        while (it.hasNext()) {
            skipped += it.skip();
        }
        return skipped;
    }

    @Override
    public Object[] decode(PositionedByteRange src) {
        int i = 0;
        Object[] ret = new Object[this.fields.length];
        StructIterator it = this.iterator(src);
        while (it.hasNext()) {
            ret[i++] = it.next();
        }
        return ret;
    }

    public Object decode(PositionedByteRange src, int index) {
        assert (index >= 0);
        StructIterator it = this.iterator(src.shallowCopy());
        while (index > 0) {
            it.skip();
            --index;
        }
        return it.next();
    }

    @Override
    public int encode(PositionedByteRange dst, Object[] val) {
        int end;
        if (val.length == 0) {
            return 0;
        }
        assert (this.fields.length >= val.length);
        int written = 0;
        for (end = val.length - 1; end > -1 && null == val[end] && (null != val[end] || this.fields[end].isNullable()); --end) {
        }
        for (int i = 0; i <= end; ++i) {
            written += this.fields[i].encode(dst, val[i]);
        }
        return written;
    }
}

