/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

@InterfaceAudience.Private
public class ZkAclReset
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ZkAclReset.class);

    private static void resetAcls(ZooKeeperWatcher zkw, String znode, boolean eraseAcls) throws Exception {
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, znode);
        if (children != null) {
            for (String child : children) {
                ZkAclReset.resetAcls(zkw, ZKUtil.joinZNode(znode, child), eraseAcls);
            }
        }
        ZooKeeper zk = zkw.getRecoverableZooKeeper().getZooKeeper();
        if (eraseAcls) {
            LOG.info((Object)(" - erase ACLs for " + znode));
            zk.setACL(znode, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, -1);
        } else {
            LOG.info((Object)(" - set ACLs for " + znode));
            zk.setACL(znode, ZKUtil.createACL(zkw, znode, true), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetAcls(Configuration conf, boolean eraseAcls) throws Exception {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "ZkAclReset", null);
        try {
            LOG.info((Object)((eraseAcls ? "Erase" : "Set") + " HBase ACLs for " + zkw.getQuorum() + " " + zkw.getBaseZNode()));
            ZkAclReset.resetAcls(zkw, zkw.getBaseZNode(), eraseAcls);
        }
        finally {
            zkw.close();
        }
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: bin/hbase %s [options]%n", ((Object)((Object)this)).getClass().getName());
        System.err.println(" where [options] are:");
        System.err.println("  -h|-help                Show this help and exit.");
        System.err.println("  -set-acls               Setup the hbase znode ACLs for a secure cluster");
        System.err.println();
        System.err.println("Examples:");
        System.err.println("  To reset the ACLs to the unsecure cluster behavior:");
        System.err.println("  hbase " + ((Object)((Object)this)).getClass().getName());
        System.err.println();
        System.err.println("  To reset the ACLs to the secure cluster behavior:");
        System.err.println("  hbase " + ((Object)((Object)this)).getClass().getName() + " -set-acls");
        System.exit(1);
    }

    public int run(String[] args) throws Exception {
        boolean eraseAcls = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-help")) {
                this.printUsageAndExit();
                continue;
            }
            if (args[i].equals("-set-acls")) {
                eraseAcls = false;
                continue;
            }
            this.printUsageAndExit();
        }
        ZkAclReset.resetAcls(this.getConf(), eraseAcls);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new ZkAclReset(), (String[])args));
    }
}

