/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;

@InterfaceAudience.Private
public class ServerStatisticTracker {
    private final Map<ServerName, ServerStatistics> stats = new ConcurrentHashMap<ServerName, ServerStatistics>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegionStats(ServerName server, byte[] region, ClientProtos.RegionLoadStats currentStats) {
        ServerStatistics stat = this.stats.get(server);
        if (stat == null) {
            ServerStatisticTracker serverStatisticTracker = this;
            synchronized (serverStatisticTracker) {
                stat = this.stats.get(server);
                if (stat == null) {
                    stat = new ServerStatistics();
                    this.stats.put(server, stat);
                }
            }
        }
        stat.update(region, currentStats);
    }

    public ServerStatistics getStats(ServerName server) {
        return this.stats.get(server);
    }

    public static ServerStatisticTracker create(Configuration conf) {
        if (!conf.getBoolean("hbase.client.backpressure.enabled", false)) {
            return null;
        }
        return new ServerStatisticTracker();
    }

    @VisibleForTesting
    ServerStatistics getServerStatsForTesting(ServerName server) {
        return this.stats.get(server);
    }
}

