/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class CatalogTracker {
    private static final Log LOG = LogFactory.getLog(CatalogTracker.class);
    private final HConnection connection;
    private final ZooKeeperWatcher zookeeper;
    private final MetaRegionTracker metaRegionTracker;
    private boolean instantiatedzkw = false;
    private Abortable abortable;
    private volatile boolean stopped = false;
    static final byte[] META_REGION_NAME = HRegionInfo.FIRST_META_REGIONINFO.getRegionName();

    public CatalogTracker(Configuration conf) throws IOException {
        this(null, conf, null);
    }

    public CatalogTracker(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) throws IOException {
        this(zk, conf, HConnectionManager.getConnection(conf), abortable);
    }

    public CatalogTracker(ZooKeeperWatcher zk, Configuration conf, HConnection connection, Abortable abortable) throws IOException {
        this.connection = connection;
        if (abortable == null) {
            this.abortable = this.connection;
        }
        Abortable throwableAborter = new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                throw new RuntimeException(why, e);
            }

            @Override
            public boolean isAborted() {
                return true;
            }
        };
        if (zk == null) {
            this.zookeeper = new ZooKeeperWatcher(conf, "catalogtracker-on-" + connection.toString(), abortable);
            this.instantiatedzkw = true;
        } else {
            this.zookeeper = zk;
        }
        this.metaRegionTracker = new MetaRegionTracker(this.zookeeper, throwableAborter);
    }

    public void start() throws IOException, InterruptedException {
        LOG.debug((Object)("Starting catalog tracker " + this));
        try {
            this.metaRegionTracker.start();
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            this.abortable.abort(e.getMessage(), t);
            throw new IOException("Attempt to start meta tracker failed.", t);
        }
    }

    @VisibleForTesting
    public boolean isStopped() {
        return this.stopped;
    }

    public void stop() {
        if (!this.stopped) {
            LOG.debug((Object)("Stopping catalog tracker " + this));
            this.stopped = true;
            this.metaRegionTracker.stop();
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Attempt to close catalog tracker's connection failed.", (Throwable)e);
            }
            if (this.instantiatedzkw) {
                this.zookeeper.close();
            }
        }
    }

    public ServerName getMetaLocation() throws InterruptedException {
        return this.metaRegionTracker.getMetaRegionLocation();
    }

    public boolean isMetaLocationAvailable() {
        return this.metaRegionTracker.isLocationAvailable();
    }

    public ServerName waitForMeta(long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        ServerName sn = this.metaRegionTracker.waitMetaRegionLocation(timeout);
        if (sn == null) {
            throw new NotAllMetaRegionsOnlineException("Timed out; " + timeout + "ms");
        }
        return sn;
    }

    public RegionState getMetaRegionState() {
        return this.metaRegionTracker.getMetaRegionState();
    }

    public AdminProtos.AdminService.BlockingInterface waitForMetaServerConnection(long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException, IOException {
        return this.getMetaServerConnection(timeout);
    }

    AdminProtos.AdminService.BlockingInterface getMetaServerConnection(long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException, IOException {
        return this.getCachedConnection(this.waitForMeta(timeout));
    }

    public void waitForMeta() throws InterruptedException {
        Stopwatch stopwatch = new Stopwatch().start();
        while (!this.stopped) {
            try {
                if (this.waitForMeta(100L) != null) break;
                long sleepTime = stopwatch.elapsedMillis();
                if ((sleepTime + 1L) % 10000L != 0L) continue;
                LOG.warn((Object)("Have been waiting for meta to be assigned for " + sleepTime + "ms"));
            }
            catch (NotAllMetaRegionsOnlineException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("hbase:meta still not available, sleeping and retrying. Reason: " + e.getMessage()));
            }
        }
    }

    private AdminProtos.AdminService.BlockingInterface getCachedConnection(ServerName sn) throws IOException {
        AdminProtos.AdminService.BlockingInterface service;
        block11: {
            if (sn == null) {
                return null;
            }
            service = null;
            try {
                service = this.connection.getAdmin(sn);
            }
            catch (RetriesExhaustedException e) {
                if (e.getCause() == null || !(e.getCause() instanceof ConnectException)) {
                    throw e;
                }
            }
            catch (SocketTimeoutException e) {
                LOG.debug((Object)("Timed out connecting to " + sn));
            }
            catch (NoRouteToHostException e) {
                LOG.debug((Object)("Connecting to " + sn), (Throwable)e);
            }
            catch (SocketException e) {
                LOG.debug((Object)("Exception connecting to " + sn));
            }
            catch (UnknownHostException e) {
                LOG.debug((Object)("Unknown host exception connecting to  " + sn));
            }
            catch (RpcClient.FailedServerException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Server " + sn + " is in failed server list."));
                }
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause();
                if (ioe instanceof ConnectException || cause != null && cause instanceof EOFException || cause != null && cause.getMessage() != null && cause.getMessage().toLowerCase().contains("connection reset")) break block11;
                throw ioe;
            }
        }
        return service;
    }

    private boolean verifyRegionLocation(AdminProtos.AdminService.BlockingInterface hostingServer, ServerName address, byte[] regionName) throws IOException {
        if (hostingServer == null) {
            LOG.info((Object)"Passed hostingServer is null");
            return false;
        }
        Throwable t = null;
        try {
            return ProtobufUtil.getRegionInfo(hostingServer, regionName) != null;
        }
        catch (ConnectException e) {
            t = e;
        }
        catch (RetriesExhaustedException e) {
            t = e;
        }
        catch (RemoteException e) {
            IOException ioe = e.unwrapRemoteException();
            t = ioe;
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            t = cause != null && cause instanceof EOFException ? cause : (cause != null && cause.getMessage() != null && cause.getMessage().contains("Connection reset") ? cause : e);
        }
        LOG.info((Object)("Failed verification of " + Bytes.toStringBinary((byte[])regionName) + " at address=" + address + ", exception=" + t));
        return false;
    }

    public boolean verifyMetaRegionLocation(long timeout) throws InterruptedException, IOException {
        AdminProtos.AdminService.BlockingInterface service = null;
        try {
            service = this.waitForMetaServerConnection(timeout);
        }
        catch (NotAllMetaRegionsOnlineException e) {
        }
        catch (ServerNotRunningYetException e) {
        }
        catch (UnknownHostException e) {
        }
        catch (RegionServerStoppedException e) {
            // empty catch block
        }
        return service == null ? false : this.verifyRegionLocation(service, this.metaRegionTracker.getMetaRegionLocation(), META_REGION_NAME);
    }

    public HConnection getConnection() {
        return this.connection;
    }
}

