/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MBeanInfoBuilder;
import org.apache.hadoop.metrics2.impl.MetricsBuilderImpl;
import org.apache.hadoop.metrics2.impl.MetricsConfig;
import org.apache.hadoop.metrics2.impl.MetricsRecordBuilderImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.util.Contracts;
import org.apache.hadoop.metrics2.util.MBeans;

class MetricsSourceAdapter
implements DynamicMBean {
    private static final Log LOG = LogFactory.getLog(MetricsSourceAdapter.class);
    private final String prefix;
    private final String name;
    private final MetricsSource source;
    private final MetricsFilter recordFilter;
    private final MetricsFilter metricFilter;
    private final HashMap<String, Attribute> attrCache;
    private final MBeanInfoBuilder infoBuilder;
    private final Iterable<MetricsTag> injectedTags;
    private Iterable<MetricsRecordImpl> lastRecs;
    private long jmxCacheTS;
    private int jmxCacheTTL;
    private MBeanInfo infoCache;
    private ObjectName mbeanName;

    MetricsSourceAdapter(String prefix, String name, String description, MetricsSource source, Iterable<MetricsTag> injectedTags, MetricsFilter recordFilter, MetricsFilter metricFilter, int jmxCacheTTL) {
        this.prefix = Contracts.checkNotNull(prefix, "prefix");
        this.name = Contracts.checkNotNull(name, "name");
        this.source = Contracts.checkNotNull(source, "source");
        this.attrCache = new HashMap();
        this.infoBuilder = new MBeanInfoBuilder(name, description);
        this.injectedTags = injectedTags;
        this.recordFilter = recordFilter;
        this.metricFilter = metricFilter;
        this.jmxCacheTTL = Contracts.checkArg(jmxCacheTTL, jmxCacheTTL > 0, (Object)"jmxCacheTTL");
    }

    MetricsSourceAdapter(String prefix, String name, String description, MetricsSource source, Iterable<MetricsTag> injectedTags, int period, MetricsConfig conf) {
        this(prefix, name, description, source, injectedTags, conf.getFilter("record.filter"), conf.getFilter("metric.filter"), period);
    }

    void start() {
        if (this.mbeanName != null) {
            LOG.warn((Object)("MBean Source " + this.name + " already initialized!"));
        }
        this.mbeanName = MBeans.register(this.prefix, this.name, this);
        LOG.info((Object)("MBean for source " + this.name + " registered."));
        LOG.debug((Object)("Stacktrace: " + new Throwable()));
    }

    @Override
    public synchronized Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        this.updateJmxCache();
        Attribute a = this.attrCache.get(attribute);
        if (a == null) {
            throw new AttributeNotFoundException(attribute + " not found");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(attribute + ": " + a.getName() + "=" + a.getValue()));
        }
        return a;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Metrics are read-only.");
    }

    @Override
    public synchronized AttributeList getAttributes(String[] attributes) {
        this.updateJmxCache();
        AttributeList ret = new AttributeList();
        for (String key : attributes) {
            Attribute attr = this.attrCache.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(key + ": " + attr.getName() + "=" + attr.getValue()));
            }
            ret.add(attr);
        }
        return ret;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("Metrics are read-only.");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        this.updateJmxCache();
        return this.infoCache;
    }

    private void updateJmxCache() {
        if (System.currentTimeMillis() - this.jmxCacheTS >= (long)this.jmxCacheTTL) {
            int numMetrics;
            int cacheSize;
            if (this.lastRecs == null) {
                MetricsBuilderImpl builder = new MetricsBuilderImpl();
                this.getMetrics(builder, true);
            }
            if ((cacheSize = this.attrCache.size()) < (numMetrics = this.updateAttrCache())) {
                this.updateInfoCache();
            }
            this.jmxCacheTS = System.currentTimeMillis();
            this.lastRecs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterable<MetricsRecordImpl> getMetrics(MetricsBuilderImpl builder, boolean all) {
        builder.setRecordFilter(this.recordFilter).setMetricFilter(this.metricFilter);
        MetricsSourceAdapter metricsSourceAdapter = this;
        synchronized (metricsSourceAdapter) {
            if (this.lastRecs == null) {
                all = true;
            }
        }
        this.source.getMetrics(builder, all);
        for (MetricsRecordBuilderImpl rb : builder) {
            for (MetricsTag t : this.injectedTags) {
                rb.add(t);
            }
        }
        metricsSourceAdapter = this;
        synchronized (metricsSourceAdapter) {
            this.lastRecs = builder.getRecords();
            return this.lastRecs;
        }
    }

    synchronized void stop() {
        MBeans.unregister(this.mbeanName);
        this.mbeanName = null;
    }

    synchronized void refreshMBean() {
        MBeans.unregister(this.mbeanName);
        this.mbeanName = MBeans.register(this.prefix, this.name, this);
    }

    private void updateInfoCache() {
        LOG.debug((Object)"Updating info cache...");
        this.infoCache = this.infoBuilder.reset(this.lastRecs).get();
        LOG.debug((Object)"Done");
    }

    private int updateAttrCache() {
        LOG.debug((Object)"Updating attr cache...");
        int recNo = 0;
        int numMetrics = 0;
        for (MetricsRecordImpl record : this.lastRecs) {
            for (MetricsTag t : record.tags()) {
                this.setAttrCacheTag(t, recNo);
                ++numMetrics;
            }
            for (Metric m : record.metrics()) {
                this.setAttrCacheMetric(m, recNo);
                ++numMetrics;
            }
            ++recNo;
        }
        LOG.debug((Object)("Done. numMetrics=" + numMetrics));
        return numMetrics;
    }

    private static String tagName(String name, int recNo) {
        StringBuilder sb = new StringBuilder(name.length() + 16);
        sb.append("tag.").append(name);
        if (recNo > 0) {
            sb.append('.').append(recNo);
        }
        return sb.toString();
    }

    private void setAttrCacheTag(MetricsTag tag, int recNo) {
        String key = MetricsSourceAdapter.tagName(tag.name(), recNo);
        this.attrCache.put(key, new Attribute(key, tag.value()));
    }

    private static String metricName(String name, int recNo) {
        if (recNo == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length() + 12);
        sb.append(name);
        if (recNo > 0) {
            sb.append('.').append(recNo);
        }
        return sb.toString();
    }

    private void setAttrCacheMetric(Metric metric, int recNo) {
        String key = MetricsSourceAdapter.metricName(metric.name(), recNo);
        this.attrCache.put(key, new Attribute(key, metric.value()));
    }

    String name() {
        return this.name;
    }

    MetricsSource source() {
        return this.source;
    }
}

