/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;

class INodeFile
extends INode {
    static final FsPermission UMASK = FsPermission.createImmutable((short)73);
    static final short BLOCKBITS = 48;
    static final long HEADERMASK = -281474976710656L;
    protected long header;
    protected BlocksMap.BlockInfo[] blocks = null;

    INodeFile(PermissionStatus permissions, int nrBlocks, short replication, long modificationTime, long atime, long preferredBlockSize) {
        this(permissions, new BlocksMap.BlockInfo[nrBlocks], replication, modificationTime, atime, preferredBlockSize);
    }

    protected INodeFile() {
        this.blocks = null;
        this.header = 0L;
    }

    protected INodeFile(PermissionStatus permissions, BlocksMap.BlockInfo[] blklist, short replication, long modificationTime, long atime, long preferredBlockSize) {
        super(permissions, modificationTime, atime);
        this.setReplication(replication);
        this.setPreferredBlockSize(preferredBlockSize);
        this.blocks = blklist;
    }

    @Override
    protected void setPermission(FsPermission permission) {
        super.setPermission(permission.applyUMask(UMASK));
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public short getReplication() {
        return (short)((this.header & 0xFFFF000000000000L) >> 48);
    }

    public void setReplication(short replication) {
        if (replication <= 0) {
            throw new IllegalArgumentException("Unexpected value for the replication");
        }
        this.header = (long)replication << 48 | this.header & 0xFFFFFFFFFFFFL;
    }

    public long getPreferredBlockSize() {
        return this.header & 0xFFFFFFFFFFFFL;
    }

    public void setPreferredBlockSize(long preferredBlkSize) {
        if (preferredBlkSize < 0L || preferredBlkSize > 0xFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Unexpected value for the block size");
        }
        this.header = this.header & 0xFFFF000000000000L | preferredBlkSize & 0xFFFFFFFFFFFFL;
    }

    BlocksMap.BlockInfo[] getBlocks() {
        return this.blocks;
    }

    void addBlock(BlocksMap.BlockInfo newblock) {
        if (this.blocks == null) {
            this.blocks = new BlocksMap.BlockInfo[1];
            this.blocks[0] = newblock;
        } else {
            int size = this.blocks.length;
            BlocksMap.BlockInfo[] newlist = new BlocksMap.BlockInfo[size + 1];
            System.arraycopy(this.blocks, 0, newlist, 0, size);
            newlist[size] = newblock;
            this.blocks = newlist;
        }
    }

    void setBlock(int idx, BlocksMap.BlockInfo blk) {
        this.blocks[idx] = blk;
    }

    @Override
    int collectSubtreeBlocksAndClear(List<Block> v) {
        this.parent = null;
        for (BlocksMap.BlockInfo blk : this.blocks) {
            v.add(blk);
        }
        this.blocks = null;
        return 1;
    }

    @Override
    long[] computeContentSummary(long[] summary) {
        long bytes = 0L;
        for (BlocksMap.BlockInfo blk : this.blocks) {
            bytes += blk.getNumBytes();
        }
        summary[0] = summary[0] + bytes;
        summary[1] = summary[1] + 1L;
        summary[3] = summary[3] + this.diskspaceConsumed();
        return summary;
    }

    @Override
    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) {
        ++counts.nsCount;
        counts.dsCount += this.diskspaceConsumed();
        return counts;
    }

    long diskspaceConsumed() {
        return this.diskspaceConsumed(this.blocks);
    }

    long diskspaceConsumed(Block[] blkArr) {
        long size = 0L;
        for (Block blk : blkArr) {
            if (blk == null) continue;
            size += blk.getNumBytes();
        }
        if (blkArr.length > 0 && blkArr[blkArr.length - 1] != null && this.isUnderConstruction()) {
            size += this.getPreferredBlockSize() - this.blocks[this.blocks.length - 1].getNumBytes();
        }
        return size * (long)this.getReplication();
    }

    Block getPenultimateBlock() {
        if (this.blocks == null || this.blocks.length <= 1) {
            return null;
        }
        return this.blocks[this.blocks.length - 2];
    }

    INodeFileUnderConstruction toINodeFileUnderConstruction(String clientName, String clientMachine, DatanodeDescriptor clientNode) throws IOException {
        if (this.isUnderConstruction()) {
            return (INodeFileUnderConstruction)this;
        }
        return new INodeFileUnderConstruction(this.name, this.getReplication(), this.modificationTime, this.getPreferredBlockSize(), this.blocks, this.getPermissionStatus(), clientName, clientMachine, clientNode);
    }
}

