/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import com.yahoo.ycsb.db.RemoteCacheManagerHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanRemoteClient
extends DB {
    private RemoteCacheManager remoteIspnManager;
    private String cacheName = null;
    private static final Log logger = LogFactory.getLog(InfinispanRemoteClient.class);

    public void init() throws DBException {
        this.remoteIspnManager = RemoteCacheManagerHolder.getInstance(this.getProperties());
        this.cacheName = this.getProperties().getProperty("cache");
    }

    public void cleanup() {
        this.remoteIspnManager.stop();
        this.remoteIspnManager = null;
    }

    public int insert(String table, String recordKey, HashMap<String, ByteIterator> values) {
        String compositKey = this.createKey(table, recordKey);
        HashMap stringValues = new HashMap();
        StringByteIterator.putAllAsStrings(stringValues, values);
        try {
            this.cache().put((Object)compositKey, stringValues);
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int read(String table, String recordKey, Set<String> fields, HashMap<String, ByteIterator> result) {
        String compositKey = this.createKey(table, recordKey);
        try {
            Map values = (Map)this.cache().get((Object)compositKey);
            if (values == null || values.isEmpty()) {
                return 2;
            }
            if (fields == null) {
                StringByteIterator.putAllAsByteIterators(result, (Map)values);
            } else {
                for (String field : fields) {
                    String value = (String)values.get(field);
                    if (value == null) continue;
                    result.put(field, (ByteIterator)new StringByteIterator(value));
                }
            }
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        logger.warn((Object)"Infinispan does not support scan semantics");
        return 4;
    }

    public int update(String table, String recordKey, HashMap<String, ByteIterator> values) {
        String compositKey = this.createKey(table, recordKey);
        try {
            HashMap stringValues = new HashMap();
            StringByteIterator.putAllAsStrings(stringValues, values);
            this.cache().put((Object)compositKey, stringValues);
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int delete(String table, String recordKey) {
        String compositKey = this.createKey(table, recordKey);
        try {
            this.cache().remove((Object)compositKey);
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private RemoteCache<String, Map<String, String>> cache() {
        if (this.cacheName != null) {
            return this.remoteIspnManager.getCache(this.cacheName);
        }
        return this.remoteIspnManager.getCache();
    }

    private String createKey(String table, String recordKey) {
        return table + "-" + recordKey;
    }
}

