/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanClient
extends DB {
    private static final int OK = 0;
    private static final int ERROR = -1;
    private static final int NOT_FOUND = -2;
    private final boolean clustered = Boolean.getBoolean("infinispan.clustered");
    private EmbeddedCacheManager infinispanManager;
    private static final Log logger = LogFactory.getLog(InfinispanClient.class);

    public void init() throws DBException {
        try {
            this.infinispanManager = new DefaultCacheManager("infinispan-config.xml");
        }
        catch (IOException e) {
            throw new DBException((Throwable)e);
        }
    }

    public void cleanup() {
        this.infinispanManager.stop();
        this.infinispanManager = null;
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        try {
            Object row;
            if (this.clustered) {
                row = AtomicMapLookup.getAtomicMap((Cache)this.infinispanManager.getCache(table), (Object)key, (boolean)false);
            } else {
                Cache cache = this.infinispanManager.getCache(table);
                row = (Map)cache.get((Object)key);
            }
            if (row != null) {
                result.clear();
                if (fields == null || fields.isEmpty()) {
                    StringByteIterator.putAllAsByteIterators(result, (Map)row);
                } else {
                    for (String field : fields) {
                        result.put(field, (ByteIterator)new StringByteIterator((String)row.get(field)));
                    }
                }
            }
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        logger.warn((Object)"Infinispan does not support scan semantics");
        return 0;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            if (this.clustered) {
                AtomicMap row = AtomicMapLookup.getAtomicMap((Cache)this.infinispanManager.getCache(table), (Object)key);
                StringByteIterator.putAllAsStrings((Map)row, values);
            } else {
                Cache cache = this.infinispanManager.getCache(table);
                Map row = (Map)cache.get((Object)key);
                if (row == null) {
                    row = StringByteIterator.getStringMap(values);
                    cache.put((Object)key, (Object)row);
                } else {
                    StringByteIterator.putAllAsStrings((Map)row, values);
                }
            }
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            if (this.clustered) {
                AtomicMap row = AtomicMapLookup.getAtomicMap((Cache)this.infinispanManager.getCache(table), (Object)key);
                row.clear();
                StringByteIterator.putAllAsStrings((Map)row, values);
            } else {
                this.infinispanManager.getCache(table).put((Object)key, values);
            }
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int delete(String table, String key) {
        try {
            if (this.clustered) {
                AtomicMapLookup.removeAtomicMap((Cache)this.infinispanManager.getCache(table), (Object)key);
            } else {
                this.infinispanManager.getCache(table).remove((Object)key);
            }
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

