/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.util.log;

import com.allanbank.mongodb.util.log.AbstractLog;
import com.allanbank.mongodb.util.log.JulLog;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import com.allanbank.mongodb.util.log.Slf4jLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Slf4jLogFactory
extends LogFactory {
    private final Class<?> myLocationAwareLoggerClass;
    private final Method myLogFactoryMethod;
    private final Method myLogMethod;

    public Slf4jLogFactory() throws RuntimeException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.slf4j.LoggerFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        try {
            this.myLogFactoryMethod = clazz.getMethod("getLogger", Class.class);
            this.myLocationAwareLoggerClass = Class.forName("org.slf4j.spi.LocationAwareLogger");
            Class<?> clazz2 = Class.forName("org.slf4j.Marker");
            this.myLogMethod = this.myLocationAwareLoggerClass.getMethod("log", clazz2, String.class, Integer.TYPE, String.class, Object[].class, Throwable.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(Slf4jLogFactory.class.getName()).log(Level.WARNING, "Failed bootstrap the SLF4J logger: " + classNotFoundException.getMessage(), classNotFoundException);
            throw new RuntimeException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger(Slf4jLogFactory.class.getName()).log(Level.WARNING, "Failed bootstrap the SLF4J logger: " + noSuchMethodException.getMessage(), noSuchMethodException);
            throw new RuntimeException(noSuchMethodException);
        }
    }

    @Override
    protected Log doGetLog(Class<?> clazz) {
        AbstractLog abstractLog = null;
        try {
            Object object = this.myLogFactoryMethod.invoke(null, clazz);
            if (this.myLocationAwareLoggerClass.isInstance(object)) {
                abstractLog = new Slf4jLog(this.myLogMethod, object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (abstractLog == null) {
            Logger.getLogger(Slf4jLogFactory.class.getName()).warning("Falling back to the JUL logger.");
            abstractLog = new JulLog(clazz);
        }
        return abstractLog;
    }
}

