/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.util.log;

import com.allanbank.mongodb.util.log.AbstractLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Slf4jLog
extends AbstractLog {
    private final Object myDelegate;
    private final Method myLogMethod;

    protected Slf4jLog(Method method, Object object) {
        this.myDelegate = object;
        this.myLogMethod = method;
    }

    @Override
    protected final void doLog(Level level, Throwable throwable, String string, Object ... objectArray) {
        try {
            this.myLogMethod.invoke(this.myDelegate, null, CLASS_NAME, this.toInt(level), string, objectArray, throwable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(Slf4jLog.class.getName()).log(Level.WARNING, "Failed to log a message: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(Slf4jLog.class.getName()).log(Level.WARNING, "Failed to log a message: " + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(Slf4jLog.class.getName()).log(Level.WARNING, "Failed to log a message: " + invocationTargetException.getMessage(), invocationTargetException);
        }
    }

    private Integer toInt(Level level) {
        int n;
        int n2 = n = level != null ? level.intValue() : 0;
        if (n == 0) {
            return 0;
        }
        if (n <= Level.FINE.intValue()) {
            return 10;
        }
        if (n <= Level.INFO.intValue()) {
            return 20;
        }
        if (n <= Level.WARNING.intValue()) {
            return 30;
        }
        return 40;
    }
}

