/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.util.log;

import com.allanbank.mongodb.util.log.JulLogFactory;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.Slf4jLogFactory;

public abstract class LogFactory {
    private static volatile LogFactory ourInstance;

    public static Log getLog(Class<?> clazz) {
        LogFactory logFactory = ourInstance;
        if (logFactory == null) {
            try {
                logFactory = new Slf4jLogFactory();
            }
            catch (RuntimeException runtimeException) {
                logFactory = new JulLogFactory();
            }
            ourInstance = logFactory;
        }
        return logFactory.doGetLog(clazz);
    }

    static void reset() {
        ourInstance = null;
    }

    protected LogFactory() {
    }

    protected abstract Log doGetLog(Class<?> var1);
}

